#!/usr/bin/env Rscript

test_that("test default", {
    library(raster)
    env.one <- raster::raster(nrow=3, ncol=3, xmn=0, xmx=3, ymn=0, ymx=3, crs=NA)
    env.one[] <- c(3,2,1,4,3,2,5,4,3)
    
    env.two <- raster::raster(nrow=3, ncol=3, xmn=0, xmx=3, ymn=0, ymx=3, crs=NA)
    env.two[] <- c(3,3,5,5,3,4,9,5,3)
    
    env.stack <- stack(list(env_one=env.one, env_two=env.two))
    config <- list(c("env_one", 3, 2), c("env_two", 4, 2))
    result.layer <- artificialBellResponse(env.stack, config)

    standard.result.layer <- raster(nrow=3, ncol=3, xmn=0, xmx=3, ymn=0, ymx=3, crs=NA)
    standard.result.layer[] <- c(0.8824969,0.7788008,0.5352614,0.7788008,0.8824969,0.8824969,0.0266491,0.7788008,0.8824969)

    extent.result <- compareRaster(result.layer, standard.result.layer)
    if (extent.result) {
       vector.one <- values(result.layer)
       vector.two <- values(standard.result.layer)
       expect_that(vector.one, equals(vector.two))
    } else {
       expect_that(extent.result, is_true())
    }
})

test_that("test stack (simple)", {
    library("raster")
    env.one <- raster::raster(nrow=3, ncol=3, xmn=0, xmx=3, ymn=0, ymx=3, crs=NA)
    env.one[] <- c(3,2,1,4,3,2,5,4,3)
    
    env.two <- raster::raster(nrow=3, ncol=3, xmn=0, xmx=3, ymn=0, ymx=3, crs=NA)
    env.two[] <- c(3,3,5,5,3,4,9,5,3)
    
    env.stack <- stack(list(env_one=env.one, env_two=env.two))
    config <- list(c("env_one", 3, 2), c("env_two", 4, 2))
    result.stack <- artificialBellResponse(env.stack, config, stack=TRUE)
    
    layer.number <- nlayers(result.stack)
    
    expect_that(layer.number, equals(2))
})

test_that("test compose sum", {
    library("raster")
    env.one <- raster::raster(nrow=3, ncol=3, xmn=0, xmx=3, ymn=0, ymx=3, crs=NA)
    env.one[] <- c(3,2,1,4,3,2,5,4,3)
    
    env.two <- raster::raster(nrow=3, ncol=3, xmn=0, xmx=3, ymn=0, ymx=3, crs=NA)
    env.two[] <- c(3,3,5,5,3,4,9,5,3)
    
    env.stack <- stack(list(env_one=env.one, env_two=env.two))
    config <- list(c("env_one", 3, 2), c("env_two", 4, 2))
    result.layer <- artificialBellResponse(env.stack, config, compose="sum")
    
    standard.result.layer <- raster(nrow=3, ncol=3, xmn=0, xmx=3, ymn=0, ymx=3, crs=NA)
    standard.result.layer[] <- c(1.8824969,1.7649938,1.4890276,1.7649938,1.8824969,1.8824969,0.6504676,1.7649938,1.8824969)
    
    extent.result <- compareRaster(result.layer, standard.result.layer)
    if (extent.result) {
        vector.one <- values(result.layer)
        vector.two <- values(standard.result.layer)
        expect_that(vector.one, equals(vector.two))
    } else {
        expect_that(extent.result, is_true())
    }
})