% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secret.R
\name{shake256}
\alias{shake256}
\title{SHAKE256 Extendable Output Function}
\usage{
shake256(x, bits = 256L, convert = TRUE, file)
}
\arguments{
\item{x}{object to hash. A character string or raw vector (without
attributes) is hashed 'as is'. All other objects are stream hashed using
R serialization (but without allocation of the serialized object).}

\item{bits}{[default 256L] output size of the returned hash. Must be between
8 and 2^24 and coercible to integer.}

\item{convert}{[default TRUE] if TRUE, the hash is converted to its hex
representation as a character string, if FALSE, output directly as a raw
vector, or if NA, a vector of (32-bit) integer values.}

\item{file}{character file name / path. If specified, 'x' is ignored. The
file is stream hashed, thus capable of handling files larger than memory.}
}
\value{
A character string, raw or integer vector depending on 'convert'.
}
\description{
Returns a SHAKE256 hash of the supplied object or file.
}
\details{
To produce single integer values suitable for use as random seeds
    for R's pseudo random number generators (RNGs), set 'bits' to 32 and
    'convert' to NA.
}
\section{R Serialization Stream Hashing}{

    
    Where this is used, serialization is always version 3 big-endian
    represenation and the headers (containing R version and native encoding
    information) are skipped to ensure portability across platforms.
}

\examples{
# SHAKE256 hash as character string:
shake256("secret base")

# SHAKE256 hash as raw vector:
shake256("secret base", convert = FALSE)

# SHAKE256 hash to integer:
shake256("secret base", bits = 32L, convert = NA)

# SHAKE256 hash a file:
file <- tempfile(); cat("secret base", file = file)
shake256(file = file)
unlink(file)

}
\references{
This implementation is based on one by 'The Mbed TLS
    Contributors' under the 'Mbed TLS' Trusted Firmware Project at
    \url{https://www.trustedfirmware.org/projects/mbed-tls}.
}
