% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secret.R
\name{keccak}
\alias{keccak}
\title{Keccak Cryptographic Hash Algorithms}
\usage{
keccak(x, bits = 256L, convert = TRUE, file)
}
\arguments{
\item{x}{object to hash. A character string or raw vector (without
attributes) is hashed as is. All other objects are stream hashed using
native R serialization.}

\item{bits}{integer output size of the returned hash. Must be one of 224,
256, 384 or 512.}

\item{convert}{logical \code{TRUE} to convert the hash to its hex representation
as a character string, \code{FALSE} to return directly as a raw vector, or \code{NA}
to return as a vector of (32-bit) integers.}

\item{file}{character file name / path. If specified, \code{x} is ignored. The
file is stream hashed, and the file can be larger than memory.}
}
\value{
A character string, raw or integer vector depending on \code{convert}.
}
\description{
Returns a Keccak hash of the supplied object or file.
}
\section{R Serialization Stream Hashing}{


Where this is used, serialization is always version 3 big-endian
representation and the headers (containing R version and native encoding
information) are skipped to ensure portability across platforms.

As hashing is performed in a streaming fashion, there is no materialization
of, or memory allocation for, the serialized object.
}

\examples{
# Keccak-256 hash as character string:
keccak("secret base")

# Keccak-256 hash as raw vector:
keccak("secret base", convert = FALSE)

# Keccak-224 hash as character string:
keccak("secret base", bits = 224)

# Keccak-384 hash as character string:
keccak("secret base", bits = 384)

# Keccak-512 hash as character string:
keccak("secret base", bits = 512)

# Keccak-256 hash a file:
file <- tempfile(); cat("secret base", file = file)
keccak(file = file)
unlink(file)

}
\references{
Keccak is the underlying algorithm for SHA-3, and is identical apart from the
value of the padding parameter.

The Keccak algorithm was designed by G. Bertoni, J. Daemen, M. Peeters and G.
Van Assche.

This implementation is based on one by 'The Mbed TLS Contributors' under the
'Mbed TLS' Trusted Firmware Project at
\url{https://www.trustedfirmware.org/projects/mbed-tls}.
}
