% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secsse_utils.R
\name{q_doubletrans}
\alias{q_doubletrans}
\title{Basic Qmatrix}
\usage{
q_doubletrans(traits, masterBlock, diff.conceal)
}
\arguments{
\item{traits}{vector with trait states, order of states must be the same as
tree tips, for help, see vignette.}

\item{masterBlock}{matrix of transitions among only examined states, NA in
the main diagonal, used to build the full transition rates matrix.}

\item{diff.conceal}{should the concealed states be different? Normally it
should be FALSE.}
}
\value{
Q matrix that includes both examined and concealed states, it should
be declared as the third element of idparslist.
}
\description{
Sets a Q matrix where double transitions are not allowed
}
\examples{
traits <- sample(c(0,1,2), 45,replace = TRUE) #get some traits
# For a three-state trait
masterBlock <- matrix(99,ncol = 3,nrow = 3,byrow = TRUE)
diag(masterBlock) <- NA
masterBlock[1,2] <- 6
masterBlock[1,3] <- 7
masterBlock[2,1] <- 8
masterBlock[2,3] <- 9
masterBlock[3,1] <- 10
masterBlock[3,2] <- 11
myQ <- q_doubletrans(traits,masterBlock,diff.conceal = FALSE)
# now, it can replace the Q matrix from id_paramPos
num_concealed_states <- 3
param_posit <- id_paramPos(traits,num_concealed_states)
param_posit[[3]] <- myQ
}
