% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.check_heteroscedasticity.R
\name{plot.see_check_heteroscedasticity}
\alias{plot.see_check_heteroscedasticity}
\title{Plot method for (non-)constant error variance checks}
\usage{
\method{plot}{see_check_heteroscedasticity}(x, data = NULL, ...)
}
\arguments{
\item{x}{An object.}

\item{data}{The original data used to create this object. Can be a
statistical model.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the
\code{performance::check_heteroscedasticity()} function.
}
\examples{
\dontshow{if (require("performance")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
result <- check_heteroscedasticity(m)
result
plot(result, data = m) # data required for pkgdown
\dontshow{\}) # examplesIf}
}
\seealso{
See also the vignette about \href{https://easystats.github.io/performance/articles/check_model.html}{\code{check_model()}}.
}
