% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segregation.R
\name{entropy}
\alias{entropy}
\title{Calculates the entropy of a distribution}
\usage{
entropy(data, group, weight = NULL, base = exp(1))
}
\arguments{
\item{data}{A data frame.}

\item{group}{A categorical variable or a vector of variables
contained in \code{data}.}

\item{weight}{Numeric. Only frequency weights are allowed.
(Default \code{NULL})}

\item{base}{Base of the logarithm that is used in the entropy
calculation. Defaults to the natural logarithm.}
}
\value{
A single number, the entropy.
}
\description{
Returns the entropy of the distribution defined by
\code{group}.
}
\examples{
d <- data.frame(cat = c("A", "B"), n = c(25, 75))
entropy(d, "cat", weight = "n") # => .56
# this is equivalent to -.25*log(.25)-.75*log(.75)

d <- data.frame(cat = c("A", "B"), n = c(50, 50))
# use base 2 for the logarithm, then entropy is maximized at 1
entropy(d, "cat", weight = "n", base = 2) # => 1
}
