% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/votes_update_table.R
\name{votes_update_table}
\alias{votes_update_table}
\title{Updating table with votes}
\usage{
votes_update_table(dbname, user, password, host,
  nr_term_of_office = 8, windows = .Platform$OS.type == 'windows',
  verbose = FALSE)
}
\arguments{
\item{dbname}{name of database}

\item{user}{name of user}

\item{password}{password of database}

\item{host}{name of host}

\item{nr_term_of_office}{number of term of office of Polish Diet; default: 8}

\item{windows}{information of used operation system; 
default: .Platform$OS.type == 'windows'}

\item{verbose}{if TRUE then additional info will be printed}
}
\value{
invisible NULL
}
\description{
Function \code{votes_update_table} updates a table with votes.
}
\note{
There is a possibility that someone's voice reader broke during voting
and this situation is treated like this deputy was absent. Even if deputy
made a decision, he's/she's vote is 'Nieobecny'.

All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
votes_update_table(dbname, user, password, host, 7, TRUE)
votes_update_table(dbname, user, password, host, 7, FALSE)}

}
\author{
Piotr Smuda
}

