% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semantic_dashboard.R
\name{dashboard_header}
\alias{dashboard_header}
\alias{dashboardHeader}
\title{Create a header of a dashboard.}
\usage{
dashboard_header(..., color = "", inverted = FALSE, disable = FALSE)

dashboardHeader(..., color = "", inverted = FALSE, disable = FALSE)
}
\arguments{
\item{...}{UI elements to include within the header.}

\item{color}{Color of the sidebar / text / icons (depending on the value of `inverted` parameter. \
One of \code{c("", "red", "orange", "yellow", "olive", "green", "teal", "blue", "violet", "purple", "pink", "brown", "grey", "black")}}

\item{inverted}{If FALSE sidebar will be white and text will be colored. \
If TRUE text will be white and background will be colored. Default is \code{FALSE}.}

\item{disable}{If \code{TRUE}, don't display the header.}
}
\value{
A header that can be passed to \code{\link[semantic.dashboard]{dashboardPage}}
}
\description{
Create a header of a dashboard with other additional UI elements.
}
\section{Functions}{
\itemize{
\item \code{dashboardHeader}: Create a header of a dashboard (alias for \code{dashboard_header} for compatibility with \code{shinydashboard})
}}

\examples{
if(interactive()){

  library(shiny)
  library(semantic.dashboard)

  ui <- dashboardPage(
    dashboardHeader(color = "blue"),
    dashboardSidebar(side = "left", size = "thin", color = "teal",
                     sidebarMenu(
                       menuItem(tabName = "tab1", "Tab 1"),
                       menuItem(tabName = "tab2", "Tab 2"))),
    dashboardBody(tabItems(
      tabItem(tabName = "tab1", p("Tab 1")),
      tabItem(tabName = "tab2", p("Tab 2"))))
  )

  server <- function(input, output) {
  }

  shinyApp(ui, server)
}
}
