% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_estimators.R
\name{compare_estimators}
\alias{compare_estimators}
\alias{se_ratios}
\title{Refit a 'lavaan'-Model by
Several Estimators}
\usage{
compare_estimators(object, estimators = NULL)

se_ratios(fit_list, reference = NULL)
}
\arguments{
\item{object}{A \linkS4class{lavaan}
object.}

\item{estimators}{A character vector
of the estimator supported by the
\code{estimator} argument of
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} and its wrappers,
such as \code{\link[lavaan:sem]{lavaan::sem()}} and
\code{\link[lavaan:cfa]{lavaan::cfa()}}.}

\item{fit_list}{The output
of \code{\link[=compare_estimators]{compare_estimators()}}.}

\item{reference}{The name
of the reference method
(ratios will be equal to one).
Must be one of the estimator
used on \code{\link[=compare_estimators]{compare_estimators()}}.
If \code{NULL}, the first estimator
will be used.}
}
\value{
A list of \code{lavaan} outputs,
each of them is an update of the
original output using one of the
estimators.
}
\description{
Refit a model in
'lavaan' by several lavaan-supported
estimators
}
\details{
The function simply uses
\code{\link[=lapply]{lapply()}} and \code{\link[=update]{update()}} to rerun
the analysis once for each of the
estimator using \verb{update(object, estimator = "x"}, \code{x} being the
estimator.

The results can then be compared
using \code{\link[=group_by_models]{group_by_models()}}.
}
\section{Functions}{
\itemize{
\item \code{compare_estimators()}: Refit the model with different estimators.

\item \code{se_ratios()}: A wrapper of \code{\link[=group_by_models]{group_by_models()}} that
computes the ratios of standard errors of different methods
to those of one method.

}}
\examples{

library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model <-
'
m ~ a*x
y ~ b*m
ab := a*b
'

fit <- sem(model, data = dat, fixed.x = FALSE)

# Refit the model by three different estimators
fit_more <- compare_estimators(fit, estimator = c("GLS", "MLR", "ML"))

# Use group_by_models to compare the estimates
group_by_models(fit_more, col_names = c("est", "pvalue"))

# Use se_ratios to compare standard errors
se_ratios(fit_more, reference = "ML")

}
\seealso{
\code{\link[=group_by_models]{group_by_models()}}
}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}.
}
