% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_by_groups.R
\name{group_by_groups}
\alias{group_by_groups}
\title{Group Estimates By Groups}
\usage{
group_by_groups(
  object,
  ...,
  col_names = "est",
  group_first = TRUE,
  group_labels = NULL,
  fit = NULL,
  use_standardizedSolution = FALSE
)
}
\arguments{
\item{object}{A \linkS4class{lavaan} object
or the output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} or
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.}

\item{...}{Optional arguments to be
passed to
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.
Ignored if object is an output of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} or
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}.}

\item{col_names}{A vector of the
column names in the parameter
estimate tables to be included.
Default is \code{"est"}.}

\item{group_first}{If \code{TRUE}, the
columns will be grouped by groups
first and then by columns in the
parameter estimates tables. Default
is \code{TRUE}.}

\item{group_labels}{A character
vector of group labels. Will be
assigned to group id = 1, 2, 3, etc.
If not provided. will try to be
retrieved from \code{object} if it is a
\link[lavaan:lavaan-class]{lavaan::lavaan} object.}

\item{fit}{Optional. A
\link[lavaan:lavaan-class]{lavaan::lavaan} object.
If \code{object} is a parameter estimates
table and \code{group_labels} is \code{NULL},
it will try to retrieve the group
labels from \code{fit} is supplied.}

\item{use_standardizedSolution}{If \code{TRUE}
and \code{object} is not an
estimates table,
then \code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}}
will be used to generate the table.
If \code{FALSE}, the default, then
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}} will
be used if necessary.}
}
\value{
A data-frame-like object of
the class \code{est_table}.
}
\description{
Groups parameter
estimates or other information such
as \emph{p}-values into a table with
groups as columns and parameters as
rows.
}
\examples{

library(lavaan)
set.seed(5478374)
n <- 100
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
city <- sample(c("City Alpha", "City Beta"), 100,
               replace = TRUE)
dat <- data.frame(x = x, y = y, m = m, city = city)
model <-
'
m ~ c(a1, a2)*x
y ~ c(b1, b2)*m
a1b1 := a1*b1
a2b2 := a2*b2
'
fit <- sem(model, data = dat, fixed.x = FALSE,
           group = "city")
(est <- parameterEstimates(fit))

# Group them by groups
group_by_groups(fit)

# Can also work on a parameter estimates table
# To have group labels, need to supply the fit object
group_by_groups(est, fit = fit)

# Can be used with some other functions in semhelpinghands
# when used on a parameter estimates table
group_by_groups(filter_by(est, op = "~"), fit = fit)

# Also support piping
est |> filter_by(op = "~") |>
       group_by_groups(fit = fit)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
