% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_envi_format.R
\name{fix_envi_format}
\alias{fix_envi_format}
\title{Fix ENVI outputs}
\usage{
fix_envi_format(infiles)
}
\arguments{
\item{infiles}{A vector of input filenames, in the
sen2r naming convention (\link{safe_shortname}) and ENVI format.}
}
\value{
NULL (the function is called for its side effects)
}
\description{
Internal function which changes some elements of output ENVI
files:
\itemize{
\item file extension is set to .dat if .envi (in case of files created
by \code{writeRaster}) is found, and the header is edited properly,
\item and band names are set in the header file (in particular, SR band names
include wavelengths and names like NIR, SWIR; other products shows the
product name as band name);
\item SCL headers include information about class names and colours.
}
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
