% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samp_physig.R
\name{samp_physig}
\alias{samp_physig}
\title{Sensitivity Analysis Species Sampling  - Phylogenetic signal}
\usage{
samp_physig(
  trait.col,
  data,
  phy,
  n.sim = 30,
  breaks = seq(0.1, 0.5, 0.1),
  method = "K",
  track = TRUE,
  ...
)
}
\arguments{
\item{trait.col}{The name of a column in the provided data frame with trait 
to be analyzed  (e.g. "Body_mass").}

\item{data}{Data frame containing species traits with row names matching tips
in \code{phy}.}

\item{phy}{A phylogeny (class 'phylo') matching \code{data}.}

\item{n.sim}{The number of times to repeat species random removal for each
\code{break} interval.}

\item{breaks}{A vector containing the percentages of species to remove.}

\item{method}{Method to compute signal: can be "K" or "lambda".}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{\link[phytools]{phylosig}}}
}
\value{
The function \code{samp_phylosig} returns a list with the following
components:

\code{Trait}: Column name of the trait analysed

\code{full.model.estimates}: Phylogenetic signal (K or lambda) and 
p-value  using the full dataset (without deleted species). See 
\code{\link[phytools]{phylosig}} for details.

\code{sensi.estimates}: A data frame with all simulation
estimates. Each row represents a rerun with a given number of species
\code{n.remov} removed, representing \code{n.percent} of the full dataset.
Columns report the calculated signal estimate (\code{estimate}),
difference between reduced data signal estimate and full data signal (\code{DF}),
the percentage of change in signal compared to the full data estimate (\code{perc})
and signal p-value for the reduced data estimate(\code{pval}).

\code{sign.analysis} For each break (i.e. each percentage of species
removed) this reports the percentage of statistically significant (at p<0.05)
phylogenetic signal over all repetitions with reduced data sets.

\code{data}: Original full dataset used in the analysis.
#' @note Please be aware that dropping species may reduce power to detect 
significant signal and may partially be responsible for a potential 
effect of species removal on p-values. Please also consult standardised differences
in the (summary) output.
}
\description{
Performs analyses of sensitivity to species sampling by randomly removing
species and detecting the effects on phylogenetic 
signal estimates
}
\details{
This function randomly removes a given percentage of species (controlled by
\code{breaks}) from the full data, estimates phylogenetic
signal for a given trait (K or lambda) without these species using 
\code{\link[phytools]{phylosig}}, then
repeats the analysis many times (controlled by \code{n.sim}), stores the results and
calculates the effect of random species removal on phylogenetic signal estimates.

Output can be visualised using \code{sensi_plot}.
}
\note{
The argument "se" from \code{\link[phytools]{phylosig}} is not available in this function. Use the 
argument "V" instead with \code{\link{intra_physig}} to indicate the name of the column containing the standard 
deviation or the standard error of the trait variable instead.
}
\examples{
\dontrun{
data(alien)
alien.data<-alien$data
alien.phy<-alien$phy
# Logtransform data
alien.data$logMass <- log(alien.data$adultMass) 
# Run sensitivity analysis:
samp <- samp_physig(trait.col = "logMass", data = alien.data, n.sim = 30,
phy = alien.phy[[1]])
summary(samp)
sensi_plot(samp)
sensi_plot(samp, graphs = 1)
sensi_plot(samp, graphs = 2)
}
\dontshow{
data(alien)
# Logtransform data
alien.data$logMass <- log(alien.data$adultMass) 
# Run sensitivity analysis:
samp <- samp_physig(trait.col = "logMass", data = alien.data, 
n.sim = 3, phy = alien.phy[[1]])
summary(samp)
sensi_plot(samp)
sensi_plot(samp, graphs = 1)
sensi_plot(samp, graphs = 2)
}
}
\references{
Paterno, G. B., Penone, C. Werner, G. D. A. 
\href{http://doi.wiley.com/10.1111/2041-210X.12990}{sensiPhy: 
An r-package for sensitivity analysis in phylogenetic 
comparative methods.} Methods in Ecology and Evolution 
2018, 9(6):1461-1467.  

Werner, G.D.A., Cornwell, W.K., Sprent, J.I., Kattge, J. & Kiers, E.T. (2014).
 A single evolutionary innovation drives the deep evolution of symbiotic N2-fixation
  in angiosperms. Nature Communications, 5, 4087.
  
Blomberg, S. P., T. Garland Jr., A. R. Ives (2003) 
Testing for phylogenetic signal in comparative data: 
Behavioral traits are more labile. Evolution, 57, 717-745.

Pagel, M. (1999) Inferring the historical patterns of biological evolution. 
Nature, 401, 877-884.

Kamilar, J. M., & Cooper, N. (2013). Phylogenetic signal in primate behaviour,
 ecology and life history. Philosophical Transactions of the Royal Society 
 B: Biological Sciences, 368: 20120341.
}
\seealso{
\code{\link[phytools]{phylosig}}, 
\code{\link{samp_phylm}},\code{\link{sensi_plot}}
}
\author{
Gustavo Paterno & Gijsbert D.A. Werner
}
