% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sobol.R
\name{plot_uncertainty}
\alias{plot_uncertainty}
\title{Plot model output uncertainty}
\usage{
plot_uncertainty(Y, n = NULL)
}
\arguments{
\item{Y}{A numeric vector with the model output.}

\item{n}{An integer with the initial sample size.}
}
\value{
a ggplot2 object.
}
\description{
It creates an histogram with the model output distribution.
}
\examples{
# Define settings:
n <- 100; k <- 8; R <- 10
# Design the sample matrix:
A <- sobol_matrices(n = n, k = k, second = FALSE, third = FALSE)
# Compute the model output:
Y <- sobol_Fun(A)
# Plot the model output distribution:
plot_uncertainty(Y, n = n)
}
