\name{radioactivePlumes}

\alias{radioactivePlumes}

%\alias{plumes_polygrid}
%\alias{population_polygrid}
%\alias{radioactivePlumes_area}
%\alias{radioactivePlumes_local}

\docType{data}

\title{
Simulations of radioactive plumes
}
\description{
The simulations show maps of pollution spreading from a single source in the centre. 
The simulations were generated by the atmospheric dispersion model RIMPUFF.
The maps show radioactivity after a release of 6 nuclids, of about 1e+13 Bq/s each, during 12 hours. The nuclids represent typical half-lives and deposition characteristics to simplify release patterns that are used in radiological emergency simulations.
The weather data was taken from a flat, coastal area in marine middle Europe. It covers one year, a new simulation starting about every week (6 days + 6 hours) and running for one day.
The size of the map is 41 km x 41 km, the resolution is telescopic: 0.5 km up to 5 km from the source, 1 km else.
The simulations were generated within the EU FP7 project DETECT, for details see the reference. Bigger, more realistic datasets can be found in the package \code{simulations4plumesData} on GitHub whereof this is a subset.
}

\details{
The three kinds of the \code{values} are summaries over plumes in time. For each location they give: \cr
\code{finaldose}: total dose after a week, in Sv;\cr
\code{maxdose}: maximal hourly average dose within the week, in Sv/h;\cr
\code{time}: time until the hourly average dose first reaches 1e-7 Sv/h, in seconds.\cr
\code{maxdose} and \code{time} may be used to determine where and when a plume can be detected at a detection level of 1e-7 Sv/h. \code{finaldose} is of interest for total impact and may for example been combined with population data.
\cr
In \code{plumes}:\cr
\code{date} indicates when it was started; \cr
The exact source location is secret according to the rules of the DETECT project from which the data was taken. Thus the location parameters have been anonymised, the projection is arbitrary. 

The values actually needed in many examples can be computed from the given data. They are added by running \code{demo(radioactivePlumes_addProperties)}: \cr
In \code{values} the layer \code{detectable} indicates weather \code{maxdose} exceeds the threshold of 1e-7 Sv/h here. \cr
In \code{locations} the \code{area} is given in km^2. \cr
In \code{plumes} the \code{totalDose} is the area weighted sum of \code{finaldose} over the whole area in Sv and \code{nDetectable} is the number of locations where \code{detectable} is TRUE.
%\code{population} in inhabitants per km^2

%Also population is not taken from the same area but from an anonymous area in Europe. \cr
}

%data(radioactivePlumes)

\usage{
data(radioactivePlumes)
}
\format{
 \code{radioactivePlumes}: \code{\link{Simulations}}
}

\references{
K.B. Helle, T.O. M{\"u}ller, P. Astrup, J.E. Dyve (2014). Automatic Optimisation of Gamma Dose Rate Sensor Networks: The DETECT Optimisation Tool. Computers \& Geosciences (66), 158-167.
}
\author{ Kristina B. Helle, \email{kristina.helle@uni-muenster.de} }

\examples{
data(radioactivePlumes)
plot(radioactivePlumes, zcol = 2)
# plot first plume, all kinds of values
spplotLog(extractSpatialDataFrame(radioactivePlumes, plumes = 1)) 
demo(radioactivePlumes_addProperties)
plot(radioactivePlumes, zcol = 2)
spplot(radioactivePlumes@locations)
plot(radioactivePlumes@plumes$totalDose)
}
\keyword{datasets}
