% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmute_se.R
\name{transmute_se}
\alias{transmute_se}
\title{transmute standard interface.}
\usage{
transmute_se(.data, transmuteTerms, env = parent.frame(), warn = TRUE)
}
\arguments{
\item{.data}{data.frame}

\item{transmuteTerms}{character vector of column expressions to transmute by.}

\item{env}{environment to work in.}

\item{warn}{logical, if TRUE warn about possible name collisions.}
}
\value{
.data transumuted by transmuteTerms.
}
\description{
transmute a data frame by the transmuteTerms.  Accepts arbitrary text as
transmuteTerms to allow forms such as "Sepal.Length >= 2 * Sepal.Width".
}
\examples{


datasets::iris \%.>\%
  transmute_se(., qae(Sepal_Long := Sepal.Length >= 2 * Sepal.Width,
                      Petal_Short := Petal.Length <= 3.5)) \%.>\%
  summary(.)


}
\seealso{
\code{\link[dplyr]{transmute}}, \code{\link[dplyr]{transmute_at}}, \code{\link[wrapr]{:=}}
}
