% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_transmute.R
\name{group_transmute}
\alias{group_transmute}
\title{group_by and transmute as an atomic action.}
\usage{
group_transmute(
  d,
  groupingVars,
  ...,
  arrangeTerms = NULL,
  env = parent.frame()
)
}
\arguments{
\item{d}{data.frame}

\item{groupingVars}{character vector of column names to group by.}

\item{...}{list of dplyr::transmute() expressions.}

\item{arrangeTerms}{character optional vector of quoted column expressions to arrange by.}

\item{env}{environment to work in.}
}
\value{
d transmuteed by groups
}
\description{
Group a data frame by the groupingVars and compute user summaries on
this data frame (user summaries specified in ...).  Enforces the
good dplyr pipeline design principle of keeping group_by and
transmute close together.
Author: John Mount, Win-Vector LLC.
}
\examples{


group_transmute(datasets::mtcars,
                    c("cyl", "gear"),
                    group_mean_mpg = mean(mpg),
                    group_mean_disp = mean(disp)) \%.>\%
  head(.)

}
