\name{readVCFToMatrixByRange}
\alias{readVCFToMatrixByRange}
\title{Read a gene from VCF file and return a genotypes matrix}
\usage{
  readVCFToMatrixByRange(fileName, range, annoType)
}
\arguments{
  \item{fileName}{character, represents an input VCF file
  (Bgzipped, with Tabix index)}

  \item{range}{character, a text indicating which range in
  the VCF file to extract. e.g. 1:100-200}

  \item{annoType}{character, annotated types you would like
  to extract, such as "Nonsynonymous", "Synonymous". This
  can be left empty.}
}
\value{
  genotype matrix
}
\description{
  Read a gene from VCF file and return a genotypes matrix
}
\examples{
fileName = system.file("vcf/all.anno.filtered.extract.vcf.gz", package = "seqminer")
cfh <- readVCFToMatrixByRange(fileName, "1:196621007-196716634", "Nonsynonymous")
}
\seealso{
  http://zhanxw.com/seqminer/ for online manual and
  examples
}

