% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqminer.R
\name{rvmeta.writeCovData}
\alias{rvmeta.writeCovData}
\title{Write covariance association statistics files.}
\usage{
rvmeta.writeCovData(rvmetaData, outName)
}
\arguments{
\item{rvmetaData}{a list vector. It's usually read by rvmeta.readDataByRange or rvmeta.readDataByGene function}

\item{outName}{character, a text indicating output file prefix}
}
\value{
TRUE only if succeed
}
\description{
Write covariance association statistics files.
}
\examples{
scoreFileName = system.file("rvtests/rvtest.MetaScore.assoc.anno.gz", package = "seqminer")
covFileName = system.file("rvtests/rvtest.MetaCov.assoc.gz", package = "seqminer")
geneFile = system.file("vcf/refFlat_hg19_6col.txt.gz", package = "seqminer")
cfh <- rvmeta.readDataByRange(scoreFileName, covFileName, "1:196621007-196716634")

outFile <- file.path(tempdir(), "cfh.MetaCov.assoc.gz")
rvmeta.writeCovData(cfh, outFile)
cat('Outputted MetaCov file are in the temp directory:', outFile, '\\n')
}
\seealso{
http://zhanxw.com/seqminer/ for online manual and examples
}
