% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNPstats.R
\name{EstErr}
\alias{EstErr}
\title{Estimate genotyping error rate}
\usage{
EstErr(GenoM, Par, ErrFlavour = "version2.0")
}
\arguments{
\item{GenoM}{Genotype matrix, in sequoia's format: 1 column per SNP, 1 row
per individual, genotypes coded as 0/1/2/-9, and rownames giving individual
IDs.}

\item{Par}{Pedigree, only genotyped parents are used.}

\item{ErrFlavour}{function that takes the genotyping error rate \code{Err} as
input, and returns a 3x3 matrix of observed (columns) conditional on actual
(rows) genotypes, or choose from inbuilt ones as used in sequoia
'version2.0', 'version1.3', or 'version1.1'. See \code{\link{ErrToM}}.}
}
\value{
a dataframe with columns:
\item{Err.hat}{Error rate, as estimated from the joined offspring-parent
  (-parent) genotypes and the presumed error structure (\code{ErrFlavour})}
\item{n.dam, n.sire, n.pair}{Number of dams, sires, parent-pairs succesfully
  genotyped for the SNP}
\item{OHdam, OHsire}{Count of number of opposing homozygous cases}
\item{MEpair}{Count of Mendelian errors, includes opposing homozygous cases}
}
\description{
Estimate genotyping error rate from Mendelian errors per SNP.
}
\seealso{
\code{\link{SnpStats}}
}
\keyword{internal}
