% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRelM.R
\name{GetRelA}
\alias{GetRelA}
\title{Array with Pairwise Relationships}
\usage{
GetRelA(Ped = NULL, GenBack = 1, patmat = TRUE, directed = TRUE, List = FALSE)
}
\arguments{
\item{Ped}{dataframe with columns id - dam - sire.}

\item{GenBack}{number of generations back to consider; 1 returns
parent-offspring and sibling relationships, 2 also returns grand-parental,
avuncular and first cousins.}

\item{patmat}{logical, distinguish between paternal versus maternal relative
pairs? For avuncular pairs, the distinction is never made.}

\item{directed}{logical, distinguish between 'O' vs 'P' or group into 'PO' ?}

\item{List}{logical, return a list instead of the default array}
}
\value{
a 3D array indicating if the pair has the specified relationship (1)
or not (0). The various relationship considered are in the 3rd dimension:
 \item{M}{}
 \item{P}{}
 \item{FS}{full siblings, including double 'other half sibs'}
 \item{MS}{}
 \item{PS}{}
 \item{XS}{other sibs: mother of A is father of B, or vv}
etc.
}
\description{
Generate an array indicating the relationship(s) between all
 pairs of individuals according to the pedigree.
}
\keyword{internal}
