test_that("construction", {
  expect_silent(Multiset$new(1, 2, 3))
  expect_silent(Multiset$new(1, 2, 3, 1))
  expect_silent(Multiset$new("A", TRUE, as.factor("a")))
  expect_silent(Multiset$new(1 + 0i, 2, 2L, 5.67))
  expect_silent(Multiset$new(1:10))
  expect_silent(Multiset$new(list(a = 1)))
  expect_silent(Multiset$new(Set$new(2), Interval$new(1, 5)))
  expect_error(Multiset$new(1, 2, universe = c(1, 2, 3)))
  expect_silent(Multiset$new(1, 2, universe = Set$new(1, 2, 3)))
})

test_that("inherited_methods", {
  expect_equal(Multiset$new(1, 2)$type, "{}")
  expect_equal(Multiset$new(1, 2, 3)$elements, list(1, 2, 3))
  expect_equal(Multiset$new(1, 2, 3)$length, 3)
  expect_true(Multiset$new(1, 3, 0.9)$contains(1))
  expect_false(Multiset$new(1, 0.1, 2, 0.3, 3, 0.9)$contains(5))
  expect_equal(Multiset$new(1, 2)$strprint(), "{1, 2}")
})

test_that("equals", {
  expect_true(Multiset$new(1, 2, 3)$equals(Multiset$new(1, 2, 3)))
  expect_true(Multiset$new(Set$new(1), 2, 3)$equals(Multiset$new(Set$new(1), 2, 3)))
  expect_true(Multiset$new(1, 2, 3)$equals(Interval$new(1, 3, class = "integer")))
  expect_true(Multiset$new(1, 2, 3)$equals(FuzzyMultiset$new(elements = 1:3)))
  expect_false(Multiset$new(1, 2, 3)$equals(Multiset$new(1, 2, 3, 2, 3, 3)))
  expect_true(Multiset$new(1, 2, 3)$equals(Multiset$new(2, 1, 3)))
  expect_false(Multiset$new(1, 2, 3)$equals(1))
  expect_false(Multiset$new(1, 2, 3)$equals(ConditionalSet$new(function(x) TRUE)))
  expect_true(Multiset$new(Set$new(1), 2) == Multiset$new(Set$new(1), 2))
  expect_false(Multiset$new(Set$new(1), 2) != Multiset$new(2, Set$new(1)))
  expect_true(Multiset$new(Set$new(1), 2) != Multiset$new(2))
  expect_true(Multiset$new(1, 2) == Interval$new(1, 2, class = "integer"))
})

test_that("isSubset", {
  expect_true(Multiset$new(1, 2, 3)$isSubset(Multiset$new(1, 2, 3)))
  expect_false(Multiset$new(1, 2, 3)$isSubset(Multiset$new(1, 2, 3), proper = TRUE))
  expect_true(Multiset$new(1, 2, 3)$isSubset(Multiset$new(3, 1, 2)))
  expect_true(Multiset$new(1, 2, 3)$isSubset(Multiset$new(3, 1)))
  expect_true(Multiset$new(1, 2, 3)$isSubset(Multiset$new(1, 3)))
  expect_true(Multiset$new(1, 2, 3)$isSubset(Multiset$new(1, 2)))
  expect_true(Multiset$new(1, 2, 3)$isSubset(FuzzySet$new(elements = 1:2)))
  expect_true(Multiset$new(1, 2, 3)$isSubset(Multiset$new(1, 2), proper = TRUE))
  expect_true(Multiset$new(1, 2, 3)$isSubset(Set$new(1, 2, 3)))
  expect_false(Multiset$new(1)$isSubset(Multiset$new(elements = 1:2)))
  expect_false(Multiset$new(elements = 1:2)$isSubset(Multiset$new(elements = 3:4)))
  expect_false(Multiset$new(1, 2, 3)$isSubset(Multiset$new(4)))
  expect_false(Multiset$new(1, 2, 3)$isSubset(4))
  expect_false(Multiset$new(1, 2, 3)$isSubset(FuzzySet$new(1, 0.5)))

  expect_equal(c(Multiset$new(1), Multiset$new(2, 4), Multiset$new(5), Multiset$new(1, 2, 3, 4)) < Multiset$new(1, 2, 3, 4), c(TRUE, TRUE, FALSE, FALSE))
  expect_equal(c(Multiset$new(1), Multiset$new(2, 4), Multiset$new(5), Multiset$new(1, 2, 3, 4)) <= Multiset$new(1, 2, 3, 4), c(TRUE, TRUE, FALSE, TRUE))
  expect_false(Multiset$new(1, 2, 3, 4)$isSubset(c(Multiset$new(1), Multiset$new(2, 4), Multiset$new(5)), all = TRUE))

  expect_true(Multiset$new(1, 2)$isSubset(Interval$new(1, 2, class = "integer")))
})

test_that("as.Multiset", {
  expect_equal(as.Multiset(c(1, 2)), Multiset$new(1, 2, class = "numeric"))
  expect_equal(as.Multiset(list(1:2, 2)), list(Multiset$new(elements = 1:2), Multiset$new(2)))
  expect_equal(as.Multiset(matrix(c(1, 2, 3, 4), nrow = 2)), list(Multiset$new(1, 2), Multiset$new(3, 4)))
  expect_equal(as.Multiset(FuzzySet$new(1, 0.1, 2, 0.2)), Multiset$new(1, 2))
  expect_equal(as.Multiset(Set$new(elements = 1:5)), Multiset$new(elements = 1:5))
  expect_error(expect_equal(as.Multiset(Interval$new()), Interval$new()), "Interval cannot")
  expect_error(expect_equal(as.Multiset(ConditionalSet$new(function(x) TRUE)), ConditionalSet$new(function(x) TRUE)), "ConditionalSet cannot be")
})
