% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{forecast.setarforest}
\alias{forecast.setarforest}
\title{Forecast method for SETAR-Forest fits}
\usage{
\method{forecast}{setarforest}(object, newdata, h = 5, level = c(80, 95), ...)
}
\arguments{
\item{object}{An object of class \code{\link{setarforest}} which is a trained SETAR-Forest model.}

\item{newdata}{A list of time series which need forecasts or a dataframe/matrix of new instances which need predictions.}

\item{h}{The required number of forecasts (forecast horizon). This parameter is only required when \code{newdata} is a list of time series. Default value is 5.}

\item{level}{Confidence level for prediction intervals. Default value is c(80, 95).}

\item{...}{Other arguments.}
}
\value{
If \code{newdata} is a list of time series, then an object of class \code{mforecast} is returned.
The \code{plot} or \code{autoplot} functions in the R \code{forecast} package can then be used to produce a plot of any time series in the returned object which contains the following properties.
\item{method}{A vector containing the name of the forecasting method ("SETAR-Forest").}
\item{forecast}{A list of objects of class \code{forecast}.
Each list object is corresponding with a time series and its forecasts.
Each list object contains 7 properties:
method (the name of the forecasting method, SETAR-Forest, as a character string),
x (the original time series),
mean (point forecasts as a time series),
series (the name of the series as a character string),
upper (upper bound of confidence intervals),
lower (lower bound of confidence intervals) and
level (confidence level of prediction intervals).}
If \code{newdata} is a dataframe/matrix, then a list containing the prediction and prediction intervals (upper and lower bounds) of each instance is returned.
}
\description{
Obtains forecasts for a given set of time series or a dataframe/matrix of new instances from a fitted SETAR-Forest model.
}
\examples{
\donttest{
# Obtaining forecasts for a list of time series
forest1 <- setarforest(chaotic_logistic_series, bagging_freq = 2)
forecast(forest1, chaotic_logistic_series)

# Obtaining forecasts for a set of test instances
forest2 <- setarforest(data = web_traffic_train[,-1],
                       label = web_traffic_train[,1],
                       bagging_freq = 2,
                       categorical_covariates = "Project")
forecast(forest2, web_traffic_test)
}

}
