% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfaselectioncross.R
\name{sfaselectioncross}
\alias{sfaselectioncross}
\alias{print.sfaselectioncross}
\alias{bread.sfaselectioncross}
\alias{estfun.sfaselectioncross}
\title{Sample selection in stochastic frontier estimation using cross-section data}
\usage{
sfaselectioncross(
  selectionF,
  frontierF,
  uhet,
  vhet,
  modelType = "greene10",
  logDepVar = TRUE,
  data,
  subset,
  weights,
  wscale = TRUE,
  S = 1L,
  udist = "hnormal",
  start = NULL,
  method = "bfgs",
  hessianType = 2L,
  lType = "ghermite",
  Nsub = 100,
  uBound = Inf,
  simType = "halton",
  Nsim = 100,
  prime = 2L,
  burn = 10,
  antithetics = FALSE,
  seed = 12345,
  itermax = 2000,
  printInfo = FALSE,
  intol = 1e-06,
  tol = 1e-12,
  gradtol = 1e-06,
  stepmax = 0.1,
  qac = "marquardt"
)

\method{print}{sfaselectioncross}(x, ...)

\method{bread}{sfaselectioncross}(x, ...)

\method{estfun}{sfaselectioncross}(x, ...)
}
\arguments{
\item{selectionF}{A symbolic (formula) description of the selection equation.}

\item{frontierF}{A symbolic (formula) description of the outcome (frontier) equation.}

\item{uhet}{A one-part formula to consider heteroscedasticity in the
one-sided error variance (see section \sQuote{Details}).}

\item{vhet}{A one-part formula to consider heteroscedasticity in the
two-sided error variance (see section \sQuote{Details}).}

\item{modelType}{Character string. Model used to solve the selection bias. Only the
model discussed in Greene (2010) is currently available.}

\item{logDepVar}{Logical. Informs whether the dependent variable is logged
(\code{TRUE}) or not (\code{FALSE}). Default = \code{TRUE}.}

\item{data}{The data frame containing the data.}

\item{subset}{An optional vector specifying a subset of observations to be
used in the optimization process.}

\item{weights}{An optional vector of weights to be used for weighted log-likelihood.
Should be \code{NULL} or numeric vector with positive values. When \code{NULL},
a numeric vector of 1 is used.}

\item{wscale}{Logical. When \code{weights} is not \code{NULL}, a scaling transformation
is used such that the \code{weights} sum to the sample size. Default \code{TRUE}.
When \code{FALSE} no scaling is used.}

\item{S}{If \code{S = 1} (default), a production (profit) frontier is
estimated: \eqn{\epsilon_i = v_i-u_i}. If \code{S = -1}, a cost frontier is
estimated: \eqn{\epsilon_i = v_i+u_i}.}

\item{udist}{Character string. Distribution specification for the one-sided
error term. Only the half normal distribution \code{'hnormal'} is currently
implemented.}

\item{start}{Numeric vector. Optional starting values for the maximum
likelihood (ML) estimation.}

\item{method}{Optimization algorithm used for the estimation.  Default =
\code{'bfgs'}. 11 algorithms are available: \itemize{ \item \code{'bfgs'},
for Broyden-Fletcher-Goldfarb-Shanno (see
\code{\link[maxLik:maxBFGS]{maxBFGS}}) \item \code{'bhhh'}, for
Berndt-Hall-Hall-Hausman (see \code{\link[maxLik:maxBHHH]{maxBHHH}}) \item
\code{'nr'}, for Newton-Raphson (see \code{\link[maxLik:maxNR]{maxNR}})
\item \code{'nm'}, for Nelder-Mead (see \code{\link[maxLik:maxNM]{maxNM}})
\item \code{'cg'}, for Conjugate Gradient (see \code{\link[maxLik:maxCG]{maxCG}})
\item \code{'sann'}, for Simulated Annealing (see \code{\link[maxLik:maxSANN]{maxSANN}})
\item \code{'ucminf'}, for a quasi-Newton type optimization with BFGS updating of the
inverse Hessian and soft line search with a trust region type monitoring of
the input to the line search algorithm (see \code{\link[ucminf:ucminf]{ucminf}})
\item \code{'mla'}, for general-purpose optimization based on
Marquardt-Levenberg algorithm (see \code{\link[marqLevAlg:mla]{mla}})
\item \code{'sr1'}, for Symmetric Rank 1 (see
\code{\link[trustOptim:trust.optim]{trust.optim}}) \item \code{'sparse'}, for trust
regions and sparse Hessian (see \code{\link[trustOptim:trust.optim]{trust.optim}}) \item
\code{'nlminb'}, for optimization using PORT routines (see
\code{\link[stats:nlminb]{nlminb}})}}

\item{hessianType}{Integer. If \code{1}, analytic Hessian is
returned. If \code{2}, bhhh Hessian is estimated (\eqn{g'g}). bhhh hessian is
estimated by default as the estimation is conducted in two steps.}

\item{lType}{Specifies the way the likelihood is estimated. Five possibilities are
available: \code{kronrod} for Gauss-Kronrod quadrature
(see \code{\link[stats:integrate]{integrate}}), \code{hcubature} and
\code{pcubature} for adaptive integration over hypercubes
(see \code{\link[cubature:hcubature]{hcubature}} and
\code{\link[cubature:pcubature]{pcubature}}), \code{ghermite} for Gauss-Hermite
quadrature (see \code{\link[fastGHQuad:gaussHermiteData]{gaussHermiteData}}), and
\code{msl} for maximum simulated likelihood. Default \code{ghermite}.}

\item{Nsub}{Integer. Number of subdivisions/nodes used for quadrature approaches.
Default \code{Nsub = 100}.}

\item{uBound}{Numeric. Upper bound for the inefficiency component when solving
integrals using quadrature approaches except Gauss-Hermite for which the upper
bound is automatically infinite (\code{Inf}). Default \code{uBound = Inf}.}

\item{simType}{Character string. If \code{simType = 'halton'} (Default),
Halton draws are used for maximum simulated likelihood (MSL). If
\code{simType = 'ghalton'}, Generalized-Halton draws are used for MSL. If
\code{simType = 'sobol'}, Sobol draws are used for MSL. If \code{simType =
'uniform'}, uniform draws are used for MSL. (see section \sQuote{Details}).}

\item{Nsim}{Number of draws for MSL (default 100).}

\item{prime}{Prime number considered for Halton and Generalized-Halton
draws. Default = \code{2}.}

\item{burn}{Number of the first observations discarded in the case of Halton
draws. Default = \code{10}.}

\item{antithetics}{Logical. Default = \code{FALSE}. If \code{TRUE},
antithetics counterpart of the uniform draws is computed. (see section
\sQuote{Details}).}

\item{seed}{Numeric. Seed for the random draws.}

\item{itermax}{Maximum number of iterations allowed for optimization.
Default = \code{2000}.}

\item{printInfo}{Logical. Print information during optimization. Default =
\code{FALSE}.}

\item{intol}{Numeric. Integration tolerance for quadrature approaches
(\code{kronrod, hcubature, pcubature}).}

\item{tol}{Numeric. Convergence tolerance. Default = \code{1e-12}.}

\item{gradtol}{Numeric. Convergence tolerance for gradient. Default =
\code{1e-06}.}

\item{stepmax}{Numeric. Step max for \code{ucminf} algorithm. Default =
\code{0.1}.}

\item{qac}{Character. Quadratic Approximation Correction for \code{'bhhh'}
and \code{'nr'} algorithms. If \code{'stephalving'}, the step length is
decreased but the direction is kept. If \code{'marquardt'} (default), the
step length is decreased while also moving closer to the pure gradient
direction. See \code{\link[maxLik:maxBHHH]{maxBHHH}} and
\code{\link[maxLik:maxNR]{maxNR}}.}

\item{x}{an object of class sfaselectioncross (returned by the function \code{\link{sfaselectioncross}}).}

\item{...}{additional arguments of frontier are passed to sfaselectioncross;
additional arguments of the print, bread, estfun, nobs methods are currently ignored.}
}
\value{
\code{\link{sfaselectioncross}} returns a list of class \code{'sfaselectioncross'}
containing the following elements:

\item{call}{The matched call.}

\item{selectionF}{The selection equation formula.}

\item{frontierF}{The frontier equation formula.}

\item{S}{The argument \code{'S'}. See the section \sQuote{Arguments}.}

\item{typeSfa}{Character string. 'Stochastic Production/Profit Frontier, e =
v - u' when \code{S = 1} and 'Stochastic Cost Frontier, e = v + u' when
\code{S = -1}.}

\item{Ninit}{Number of initial observations in all samples.}

\item{Nobs}{Number of observations used for optimization.}

\item{nXvar}{Number of explanatory variables in the production or cost
frontier.}

\item{logDepVar}{The argument \code{'logDepVar'}. See the section
\sQuote{Arguments}.}

\item{nuZUvar}{Number of variables explaining heteroscedasticity in the
one-sided error term.}

\item{nvZVvar}{Number of variables explaining heteroscedasticity in the
two-sided error term.}

\item{nParm}{Total number of parameters estimated.}

\item{udist}{The argument \code{'udist'}. See the section
\sQuote{Arguments}.}

\item{startVal}{Numeric vector. Starting value for M(S)L estimation.}

\item{dataTable}{A data frame (tibble format) containing information on data
used for optimization along with residuals and fitted values of the OLS and
M(S)L estimations, and the individual observation log-likelihood. When argument \code{weights}
is specified, an additional variable is provided in \code{dataTable}.}

\item{lpmObj}{Linear probability model used for initializing the first step
probit model.}

\item{probitObj}{Probit model. Object of class \code{'maxLik'} and \code{'maxim'}.}

\item{ols2stepParam}{Numeric vector. OLS second step estimates for
selection correction. Inverse Mills Ratio is introduced as an additional
explanatory variable.}

\item{ols2stepStder}{Numeric vector. Standard errors of OLS second step estimates.}

\item{ols2stepSigmasq}{Numeric. Estimated variance of OLS second step random error.}

\item{ols2stepLoglik}{Numeric. Log-likelihood value of OLS second step estimation.}

\item{ols2stepSkew}{Numeric. Skewness of the residuals of the OLS second step estimation.}

\item{ols2stepM3Okay}{Logical. Indicating whether the residuals of the OLS
second step estimation have the expected skewness.}

\item{CoelliM3Test}{Coelli's test for OLS residuals skewness. (See Coelli,
1995).}

\item{AgostinoTest}{D'Agostino's test for OLS residuals skewness. (See
D'Agostino and Pearson, 1973).}

\item{isWeights}{Logical. If \code{TRUE} weighted log-likelihood is
maximized.}

\item{lType}{Type of likelihood estimated. See the section \sQuote{Arguments}.}

\item{optType}{Optimization algorithm used.}

\item{nIter}{Number of iterations of the ML estimation.}

\item{optStatus}{Optimization algorithm termination message.}

\item{startLoglik}{Log-likelihood at the starting values.}

\item{mlLoglik}{Log-likelihood value of the M(S)L estimation.}

\item{mlParam}{Parameters obtained from M(S)L estimation.}

\item{gradient}{Each variable gradient of the M(S)L estimation.}

\item{gradL_OBS}{Matrix. Each variable individual observation gradient of
the M(S)L estimation.}

\item{gradientNorm}{Gradient norm of the M(S)L estimation.}

\item{invHessian}{Covariance matrix of the parameters obtained from the
M(S)L estimation.}

\item{hessianType}{The argument \code{'hessianType'}. See the section
\sQuote{Arguments}.}

\item{mlDate}{Date and time of the estimated model.}

\item{simDist}{The argument \code{'simDist'}, only if \code{lType =
'msl'}. See the section \sQuote{Arguments}.}

\item{Nsim}{The argument \code{'Nsim'}, only if \code{lType = 'msl'}.
See the section \sQuote{Arguments}.}

\item{FiMat}{Matrix of random draws used for MSL, only if \code{lType =
'msl'}.}

\item{gHermiteData}{List. Gauss-Hermite quadrature rule as provided by
\code{\link[fastGHQuad:gaussHermiteData]{gaussHermiteData}}. Only if \code{lType = 
'ghermite'}.}

\item{Nsub}{Number of subdivisions used for quadrature approaches.}

\item{uBound}{Upper bound for the inefficiency component when solving
integrals using quadrature approaches except Gauss-Hermite for which the upper
bound is automatically infinite (\code{Inf}).}

\item{intol}{Integration tolerance for quadrature approaches except Gauss-Hermite.}
}
\description{
\code{\link{sfaselectioncross}} is a symbolic formula based function for the
estimation of the stochastic frontier model in the presence of sample
selection. The model accommodates cross-sectional or pooled cross-sectional data.
The model can be estimated using different quadrature approaches or
maximum simulated likelihood (MSL). See Greene (2010).

Only the half-normal distribution is possible for the one-sided error term.
Eleven optimization algorithms are available.

The function also accounts for heteroscedasticity in both one-sided and
two-sided error terms, as in Reifschneider and Stevenson (1991), Caudill and
Ford (1993), Caudill \emph{et al.} (1995) and Hadri (1999).
}
\details{
The current model is an extension of Heckman (1976, 1979) sample selection model to
nonlinear models particularly stochastic frontier model. The model has first been discussed in
Greene (2010), and an application can be found in Dakpo et al. (2021). Practically, we have:

\deqn{
y_{1i} =  \left\{ \begin{array}{ll}
1 & \mbox{if} \quad y_{1i}^* > 0  \\
0 & \mbox{if} \quad y_{1i}^* \leq 0 \\
\end{array}
\right.
}

where

\deqn{
y_{1i}^*=\mathbf{Z}_{si}^{\prime} \mathbf{\gamma} + w_i, \quad 
w_i \sim \mathcal{N}(0, 1)
}

and

\deqn{
y_{2i} =  \left\{ \begin{array}{ll}
y_{2i}^* & \mbox{if} \quad y_{1i}^* > 0  \\
NA & \mbox{if} \quad y_{1i}^* \leq 0 \\
\end{array}
\right.
}

where

\deqn{
y_{2i}^*=\mathbf{x_{i}^{\prime}} \mathbf{\beta} + v_i - Su_i, \quad 
v_i = \sigma_vV_i \quad \wedge \quad V_i \sim \mathcal{N}(0, 1), \quad 
u_i = \sigma_u|U_i| \quad \wedge \quad U_i \sim \mathcal{N}(0, 1)
}

\eqn{y_{1i}} describes the selection equation while \eqn{y_{2i}} represents
the frontier equation. The selection bias arises from the correlation
between the two symmetric random components \eqn{v_i} and \eqn{w_i}:

\deqn{
(v_i, w_i) \sim \mathcal{N}_2\left\lbrack(0,0), (1, \rho \sigma_v, \sigma_v^2) \right\rbrack
}

Conditionaly on \eqn{|U_i|}, the probability associated to each observation is:

\deqn{
Pr \left\lbrack y_{1i}^* \leq 0 \right\rbrack^{1-y_{1i}} \cdot \left\lbrace 
f(y_{2i}|y_{1i}^* > 0) \times Pr\left\lbrack y_{1i}^* > 0 
\right\rbrack \right\rbrace^{y_{1i}}
}

Using the conditional probability formula:

\deqn{
P\left(A\cap B\right) = P(A) \cdot P(B|A) = P(B) \cdot P(A|B)
}

Therefore:

\deqn{
f(y_{2i}|y_{1i}^* \geq 0) \cdot Pr\left\lbrack y_{1i}^* \geq 0\right\rbrack = 
f(y_{2i}) \cdot Pr(y_{1i}^* \geq 0|y_{2i})
}

Using the properties of a bivariate normal distribution, we have:

\deqn{
y_{i1}^* | y_{i2} \sim N\left(\mathbf{Z_{si}^{\prime}} \bm{\gamma}+\frac{\rho}{
\sigma_v}v_i, 1-\rho^2\right)
}

Hence conditionally on \eqn{|U_i|}, we have:

\deqn{
f(y_{2i}|y_{1i}^* \geq 0) \cdot Pr\left\lbrack y_{1i}^* \geq 0\right\rbrack = 
\frac{1}{\sigma_v}\phi\left(\frac{v_i}{\sigma_v}\right)\Phi\left(\frac{
\mathbf{Z_{si}^{\prime}} \bm{\gamma}+\frac{\rho}{\sigma_v}v_i}{
\sqrt{1-\rho^2}}\right)
}

The conditional likelihood is equal to:

\deqn{
L_i\big||U_i| = \Phi(-\mathbf{Z_{si}^{\prime}} \bm{\gamma})^{1-y_{1i}} \times 
\left\lbrace \frac{1}{\sigma_v}\phi\left(\frac{y_{2i}-\mathbf{x_{i}^{\prime}} 
\bm{\beta} + S\sigma_u|U_i|}{\sigma_v}\right)\Phi\left(\frac{
\mathbf{Z_{si}^{\prime}} \bm{\gamma}+\frac{\rho}{\sigma_v}\left(y_{2i}-
\mathbf{x_{i}^{\prime}} \bm{\beta} + S\sigma_u|U_i|\right)}{\sqrt{1-\rho^2}}
\right) \right\rbrace ^{y_{1i}}
}

Since the non-selected observations bring no additional information,
the conditional likelihood to be considered is:

\deqn{
L_i\big||U_i| = \frac{1}{\sigma_v}\phi\left(\frac{y_{2i}-\mathbf{x_{i}^{\prime}} 
\bm{\beta} + S\sigma_u|U_i|}{\sigma_v}\right) \Phi\left(\frac{\mathbf{Z_{si}^{\prime}} 
\bm{\gamma}+\frac{\rho}{\sigma_v}\left(y_{2i}-\mathbf{x_{i}^{\prime}} \bm{\beta} + 
S\sigma_u|U_i|\right)}{\sqrt{1-\rho^2}}\right) 
}

The unconditional likelihood is obtained by integrating \eqn{|U_i|} out of the conditional likelihood. Thus

\deqn{
L_i\\ = \int_{|U_i|} \frac{1}{\sigma_v}\phi\left(\frac{y_{2i}-\mathbf{x_{i}^{\prime}} 
\bm{\beta} + S\sigma_u|U_i|}{\sigma_v}\right) \Phi\left(\frac{\mathbf{Z_{si}^{\prime}} 
\bm{\gamma}+ \frac{\rho}{\sigma_v}\left(y_{2i}-\mathbf{x_{i}^{\prime}} \bm{\beta} + 
S\sigma_u|U_i|\right)}{\sqrt{1-\rho^2}}\right)p\left(|U_i|\right)d|U_i|
}

To simplifiy the estimation, the likelihood can be estimated using a two-step approach.
In the first step, the probit model can be run and estimate of \eqn{\gamma} can be obtained.
Then, in the second step, the following model is estimated:

\deqn{
L_i\\ = \int_{|U_i|} \frac{1}{\sigma_v}\phi\left(\frac{y_{2i}-\mathbf{x_{i}^{\prime}} 
\bm{\beta} + S\sigma_u|U_i|}{\sigma_v}\right) \Phi\left(\frac{a_i + 
\frac{\rho}{\sigma_v}\left(y_{2i}-\mathbf{x_{i}^{\prime}} \bm{\beta} + 
S\sigma_u|U_i|\right)}{\sqrt{1-\rho^2}}\right)p\left(|U_i|\right)d|U_i| 
}

where \eqn{a_i = \mathbf{Z_{si}^{\prime}} \hat{\bm{\gamma}}}. This likelihood can be estimated using
five different approaches: Gauss-Kronrod quadrature, adaptive integration over hypercubes
(hcubature and pcubature), Gauss-Hermite quadrature, and
maximum simulated likelihood. We also use the BHHH estimator to obtain
the asymptotic standard errors for the parameter estimators.

\code{sfaselectioncross} allows for the maximization of weighted log-likelihood.
When option \code{weights} is specified and \code{wscale = TRUE}, the weights
are scaled as:

\deqn{
new_{weights} = sample_{size} \times \frac{old_{weights}}{\sum(old_{weights})}
}

For complex problems, non-gradient methods (e.g. \code{nm} or \code{sann}) can be
used to warm start the optimization and zoom in the neighborhood of the
solution. Then a gradient-based methods is recommended in the second step. In the case
of \code{sann}, we recommend to significantly increase the iteration limit
(e.g. \code{itermax = 20000}). The Conjugate Gradient (\code{cg}) can also be used
in the first stage.

A set of extractor functions for fitted model objects is available for objects of class
\code{'sfaselectioncross'} including methods to the generic functions \code{\link[=print.sfaselectioncross]{print}},
\code{\link[=summary.sfaselectioncross]{summary}}, \code{\link[=coef.sfaselectioncross]{coef}},
\code{\link[=fitted.sfaselectioncross]{fitted}}, \code{\link[=logLik.sfaselectioncross]{logLik}},
\code{\link[=residuals.sfaselectioncross]{residuals}}, \code{\link[=vcov.sfaselectioncross]{vcov}},
\code{\link[=efficiencies.sfaselectioncross]{efficiencies}}, \code{\link[=ic.sfaselectioncross]{ic}},
\code{\link[=marginal.sfaselectioncross]{marginal}},
\code{\link[=estfun.sfaselectioncross]{estfun}} and
\code{\link[=bread.sfaselectioncross]{bread}} (from the \CRANpkg{sandwich} package),
\code{\link[lmtest:coeftest]{lmtest::coeftest()}} (from the \CRANpkg{lmtest} package).
}
\note{
For the Halton draws, the code is adapted from the \pkg{mlogit}
package.
}
\examples{

\dontrun{

## Simulated example

N <- 2000  # sample size
set.seed(12345)
z1 <- rnorm(N)
z2 <- rnorm(N)
v1 <- rnorm(N)
v2 <- rnorm(N)
e1 <- v1
e2 <- 0.7071 * (v1 + v2)
ds <- z1 + z2 + e1
d <- ifelse(ds > 0, 1, 0)
u <- abs(rnorm(N))
x1 <- rnorm(N)
x2 <- rnorm(N)
y <- x1 + x2 + e2 - u
data <- cbind(y = y, x1 = x1, x2 = x2, z1 = z1, z2 = z2, d = d)

## Estimation using quadrature (Gauss-Kronrod)

selecRes1 <- sfaselectioncross(selectionF = d ~ z1 + z2, frontierF = y ~ x1 + x2, 
modelType = 'greene10', method = 'bfgs',
logDepVar = TRUE, data = as.data.frame(data),
S = 1L, udist = 'hnormal', lType = 'kronrod', Nsub = 100, uBound = Inf,
simType = 'halton', Nsim = 300, prime = 2L, burn = 10, antithetics = FALSE,
seed = 12345, itermax = 2000, printInfo = FALSE)

summary(selecRes1)

## Estimation using maximum simulated likelihood

selecRes2 <- sfaselectioncross(selectionF = d ~ z1 + z2, frontierF = y ~ x1 + x2, 
modelType = 'greene10', method = 'bfgs',
logDepVar = TRUE, data = as.data.frame(data),
S = 1L, udist = 'hnormal', lType = 'msl', Nsub = 100, uBound = Inf,
simType = 'halton', Nsim = 300, prime = 2L, burn = 10, antithetics = FALSE,
seed = 12345, itermax = 2000, printInfo = FALSE)

summary(selecRes2)

}

}
\references{
Caudill, S. B., and Ford, J. M. 1993. Biases in frontier estimation due to
heteroscedasticity. \emph{Economics Letters}, \bold{41}(1), 17--20.

Caudill, S. B., Ford, J. M., and Gropper, D. M. 1995. Frontier estimation
and firm-specific inefficiency measures in the presence of
heteroscedasticity. \emph{Journal of Business & Economic Statistics},
\bold{13}(1), 105--111.

Coelli, T. 1995. Estimators and hypothesis tests for a stochastic frontier
function - a Monte-Carlo analysis. \emph{Journal of Productivity Analysis},
\bold{6}:247--268.

D'Agostino, R., and E.S. Pearson. 1973. Tests for departure from normality.
Empirical results for the distributions of \eqn{b_2} and \eqn{\sqrt{b_1}}.
\emph{Biometrika}, \bold{60}:613--622.

Dakpo, K. H., Latruffe, L., Desjeux, Y., Jeanneaux, P., 2022.
Modeling heterogeneous technologies in the presence of sample selection:
The case of dairy farms and the adoption of agri-environmental schemes in France.
\emph{Agricultural Economics}, \bold{53}(3), 422-438.

Greene, W., 2010. A stochastic frontier model with correction
for sample selection. \emph{Journal of Productivity Analysis}. \bold{34}, 15--24.

Hadri, K. 1999. Estimation of a doubly heteroscedastic stochastic frontier
cost function. \emph{Journal of Business & Economic Statistics},
\bold{17}(3), 359--363.

Heckman, J., 1976. Discrete, qualitative and limited dependent variables.
\emph{Ann Econ Soc Meas.} \bold{4}, 475--492.

Heckman, J., 1979. Sample Selection Bias as a Specification Error.
\emph{Econometrica}. \bold{47}, 153--161.

Reifschneider, D., and Stevenson, R. 1991. Systematic departures from the
frontier: A framework for the analysis of firm inefficiency.
\emph{International Economic Review}, \bold{32}(3), 715--723.
}
\seealso{
\code{\link[=print.sfaselectioncross]{print}} for printing \code{sfaselectioncross} object.

\code{\link[=summary.sfaselectioncross]{summary}} for creating and printing
summary results.

\code{\link[=coef.sfaselectioncross]{coef}} for extracting coefficients of the
estimation.

\code{\link[=efficiencies.sfaselectioncross]{efficiencies}} for computing
(in-)efficiency estimates.

\code{\link[=fitted.sfaselectioncross]{fitted}} for extracting the fitted frontier
values.

\code{\link[=ic.sfaselectioncross]{ic}} for extracting information criteria.

\code{\link[=logLik.sfaselectioncross]{logLik}} for extracting log-likelihood
value(s) of the estimation.

\code{\link[=marginal.sfaselectioncross]{marginal}} for computing marginal effects of
inefficiency drivers.

\code{\link[=residuals.sfaselectioncross]{residuals}} for extracting residuals of the
estimation.

\code{\link[=vcov.sfaselectioncross]{vcov}} for computing the variance-covariance
matrix of the coefficients.

\code{\link[=bread.sfaselectioncross]{bread}} for bread for sandwich estimator.

\code{\link[=estfun.sfaselectioncross]{estfun}} for gradient extraction for each
observation.
}
\keyword{cross-section}
\keyword{likelihood}
\keyword{models}
\keyword{optimize}
