% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-measures.R
\name{global_c_perm}
\alias{global_c_perm}
\title{Global C Permutation Test}
\usage{
global_c_perm(
  x,
  nb,
  wt,
  nsim = 499,
  alternative = "greater",
  allow_zero = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{nsim}{number of simulations to run.}

\item{alternative}{default \code{"two.sided"}. Should be one of \code{"greater"}, \code{"less"}, or \code{"two.sided"} to specify the alternative hypothesis.}

\item{allow_zero}{If \code{TRUE}, assigns zero as lagged value to zone without neighbors.}

\item{...}{additional arguments passed to \code{\link[spdep:geary.mc]{spdep::geary.mc()}}.}
}
\value{
an object of classes \code{htest} and \code{mc.sim}
}
\description{
Global C Permutation Test
}
\examples{
geo <- sf::st_geometry(guerry)
nb <- st_contiguity(geo)
wt <- st_weights(nb)
x <- guerry$crime_pers
global_c_perm(x, nb, wt)
}
\seealso{
Other global_c: 
\code{\link{global_c}()},
\code{\link{global_c_test}()}
}
\concept{global_c}
