% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgl_test.R
\name{sgl_test}
\alias{sgl_test}
\title{Test a sgl-Objective}
\usage{
sgl_test(module_name, PACKAGE, data, parameterGrouping, groupWeights,
  parameterWeights, algorithm.config = sgl.standard.config)
}
\arguments{
\item{module_name}{reference to objective specific C++ routines.}

\item{PACKAGE}{name of the calling package.}

\item{data}{a list of data objects -- will be parsed to the specified module.}

\item{parameterGrouping}{grouping of parameters, a vector of length \eqn{p}. Each element of the vector specifying the group of the parameters in the corresponding column of \eqn{\beta}.}

\item{groupWeights}{the group weights, a vector of length \code{length(unique(parameterGrouping))} (the number of groups).}

\item{parameterWeights}{a matrix of size \eqn{q \times p}.}

\item{algorithm.config}{the algorithm configuration to be used.}
}
\value{
The number of found problems
}
\description{
This function will run tests on the gradient and hessian functions implemented in a C++ objective module.
Detected problems will be printed to the console.'
}
\author{
Martin Vincent
}
