% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_breaks.R
\name{strat_breaks}
\alias{strat_breaks}
\title{Breaks stratification}
\usage{
strat_breaks(
  mraster,
  mraster2 = NULL,
  breaks,
  breaks2 = NULL,
  plot = FALSE,
  details = FALSE,
  filename = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{mraster}{Spatraster. Primary covariate raster to stratify.}

\item{mraster2}{Spatraster. Secondary covariate raster to stratify.}

\item{breaks}{Numeric. Vector of breakpoints for \code{mraster}.}

\item{breaks2}{Numeric. Vector of breakpoints for \code{mraster2} (if provided).}

\item{plot}{Logical. Plots output strata raster and visualized
strata with boundary dividers.}

\item{details}{Logical. If \code{FALSE} (default) output is only
stratification raster. If \code{TRUE} return a list where \code{$details} is additional 
stratification information and \code{$raster} is the output stratification spatRaster.}

\item{filename}{Character. Path to write stratified raster to disc.}

\item{overwrite}{Logical. Specify whether \code{filename} should be overwritten on disc.}
}
\value{
Returns an output stratification \code{spatRaster} or a list when \code{details = TRUE}.

When a list is returned:
\enumerate{
\item \code{details} is a list output of the \code{\link[stats]{prcomp}} function
\item \code{raster} is a stratified \code{spatRaster} based on quantiles
\item \code{plot} is a \code{ggplot} histogram object showing distribution and break points.
}
}
\description{
Stratify metrics raster using user defined breaks
}
\examples{
#--- Load raster ---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

#--- create vector breaks ---#
br.max <- c(3, 5, 11, 18)
br.sd <- c(1, 2, 5)

strat_breaks(
  mraster = mr$zq90,
  breaks = br.max,
  plot = TRUE,
  details = TRUE
)

strat_breaks(
  mraster = mr$zq90,
  mraster2 = mr$zsd,
  breaks = br.max,
  breaks2 = br.sd
)
}
\seealso{
Other stratify functions: 
\code{\link{strat_kmeans}()},
\code{\link{strat_map}()},
\code{\link{strat_poly}()},
\code{\link{strat_quantiles}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{stratify functions}
