% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_dependence.R
\name{sv_dependence}
\alias{sv_dependence}
\alias{sv_dependence.default}
\alias{sv_dependence.shapviz}
\alias{sv_dependence.mshapviz}
\title{SHAP Dependence Plot}
\usage{
sv_dependence(object, ...)

\method{sv_dependence}{default}(object, ...)

\method{sv_dependence}{shapviz}(
  object,
  v,
  color_var = "auto",
  color = "#3b528b",
  viridis_args = getOption("shapviz.viridis_args"),
  jitter_width = NULL,
  interactions = FALSE,
  ...
)

\method{sv_dependence}{mshapviz}(
  object,
  v,
  color_var = "auto",
  color = "#3b528b",
  viridis_args = getOption("shapviz.viridis_args"),
  jitter_width = NULL,
  interactions = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class "(m)shapviz".}

\item{...}{Arguments passed to \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}}.}

\item{v}{Column name of feature to be plotted. Can be a vector/list if \code{object} is
of class "shapviz".}

\item{color_var}{Feature name to be used on the color scale to investigate
interactions. The default ("auto") uses SHAP interaction values (if available),
or a heuristic to select the strongest interacting feature. Set to \code{NULL} to not
use the color axis. Can be a vector/list if \code{object} is of class "shapviz".}

\item{color}{Color to be used if \code{color_var = NULL}. Can be a vector/list if \code{v}
is a vector.}

\item{viridis_args}{List of viridis color scale arguments, see
\code{?ggplot2::scale_color_viridis_c}. The default points to the global option
\code{shapviz.viridis_args}, which corresponds to
\code{list(begin = 0.25, end = 0.85, option = "inferno")}.
These values are passed to \verb{ggplot2::scale_color_viridis_*()}.
For example, to switch to a standard viridis scale, you can either change the
default via \code{options(shapviz.viridis_args = list())}, or set
\code{viridis_args = list()}. Only relevant if \code{color_var} is not \code{NULL}.}

\item{jitter_width}{The amount of horizontal jitter. The default (\code{NULL}) will
use a value of 0.2 in case \code{v} is discrete, and no jitter otherwise.
(Numeric variables are considered discrete if they have at most 7 unique values.)
Can be a vector/list if \code{v} is a vector.}

\item{interactions}{Should SHAP interaction values be plotted? Default is \code{FALSE}.
Requires SHAP interaction values. If \code{color_var = NULL} (or it is equal to \code{v}),
the pure main effect of \code{v} is visualized. Otherwise, twice the SHAP interaction
values between \code{v} and the \code{color_var} are plotted.}
}
\value{
An object of class "ggplot" (or "patchwork") representing a dependence plot.
}
\description{
Scatterplot of the SHAP values of a feature against its feature values.
If SHAP interaction values are available, setting \code{interactions = TRUE} allows
to focus on pure interaction effects (multiplied by two) or on pure main effects.
}
\section{Methods (by class)}{
\itemize{
\item \code{sv_dependence(default)}: Default method.

\item \code{sv_dependence(shapviz)}: SHAP dependence plot for "shapviz" object.

\item \code{sv_dependence(mshapviz)}: SHAP dependence plot for "mshapviz" object.

}}
\examples{
\dontrun{
dtrain <- xgboost::xgb.DMatrix(data.matrix(iris[, -1]), label = iris[, 1])
fit <- xgboost::xgb.train(data = dtrain, nrounds = 10, nthread = 1)
x <- shapviz(fit, X_pred = dtrain, X = iris)
sv_dependence(x, "Petal.Length")
sv_dependence(x, "Petal.Length", color_var = "Species")
sv_dependence(x, "Petal.Length", color_var = NULL)
sv_dependence(x, c("Species", "Petal.Length"))
sv_dependence(x, "Petal.Width", color_var = c("Species", "Petal.Length"))

# SHAP interaction values/main effects
x2 <- shapviz(fit, X_pred = dtrain, X = iris, interactions = TRUE)
sv_dependence(x2, "Petal.Length", interactions = TRUE)
sv_dependence(
  x2, c("Petal.Length", "Species"), color_var = NULL, interactions = TRUE
)
}
}
\seealso{
\code{\link[=potential_interactions]{potential_interactions()}}
}
