% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms.R
\name{SelectionAlgo}
\alias{SelectionAlgo}
\title{Variable selection algorithm}
\usage{
SelectionAlgo(
  xdata,
  ydata = NULL,
  Lambda,
  group_x = NULL,
  family = NULL,
  implementation = PenalisedRegression,
  ...
)
}
\arguments{
\item{xdata}{matrix of predictors with observations as rows and variables as
columns.}

\item{ydata}{optional vector or matrix of outcome(s). If \code{family} is set
to \code{"binomial"} or \code{"multinomial"}, \code{ydata} can be a vector
with character/numeric values or a factor.}

\item{Lambda}{matrix of parameters controlling the level of sparsity in the
underlying feature selection algorithm specified in \code{implementation}.
If \code{Lambda=NULL} and \code{implementation=PenalisedRegression},
\code{\link{LambdaGridRegression}} is used to define a relevant grid.}

\item{group_x}{vector encoding the grouping structure among predictors. This
argument indicates the number of variables in each group. Only used for
models with group penalisation (e.g. \code{implementation=GroupPLS} or
\code{implementation=SparseGroupPLS}).}

\item{family}{type of regression model. This argument is defined as in
\code{\link[glmnet]{glmnet}}. Possible values include \code{"gaussian"}
(linear regression), \code{"binomial"} (logistic regression),
\code{"multinomial"} (multinomial regression), and \code{"cox"} (survival
analysis).}

\item{implementation}{function to use for variable selection. Possible
functions are: \code{PenalisedRegression}, \code{SparsePLS},
\code{GroupPLS} and \code{SparseGroupPLS}. Alternatively, a user-defined
function can be provided.}

\item{...}{additional parameters passed to the function provided in
\code{implementation}.}
}
\value{
A list with: \item{selected}{matrix of binary selection status. Rows
  correspond to different model parameters. Columns correspond to
  predictors.} \item{beta_full}{array of model coefficients. Rows correspond
  to different model parameters. Columns correspond to predictors. Indices
  along the third dimension correspond to outcome variable(s).}
}
\description{
Runs the variable selection algorithm specified in the argument
\code{implementation}. This function is not using stability.
}
\examples{
# Data simulation (univariate outcome)
set.seed(1)
simul <- SimulateRegression(pk = 50)

# Running the LASSO
mylasso <- SelectionAlgo(
  xdata = simul$xdata, ydata = simul$ydata,
  Lambda = c(0.1, 0.2), family = "gaussian",
)

# Data simulation (multivariate outcome)
set.seed(1)
simul <- SimulateRegression(pk = c(15, 15, 20))

# Running multivariate Gaussian LASSO
mylasso <- SelectionAlgo(
  xdata = simul$xdata, ydata = simul$ydata,
  Lambda = c(0.1, 0.2), family = "mgaussian"
)
str(mylasso)
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{PenalisedRegression}},
  \code{\link{SparsePCA}}, \code{\link{SparsePLS}}, \code{\link{GroupPLS}},
  \code{\link{SparseGroupPLS}}

Other wrapping functions: 
\code{\link{GraphicalAlgo}()}
}
\concept{wrapping functions}
