% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{SimulateSymmetricMatrix}
\alias{SimulateSymmetricMatrix}
\title{Simulation of symmetric matrix with block structure}
\usage{
SimulateSymmetricMatrix(
  pk = 10,
  v_within = c(0.5, 1),
  v_between = c(0, 0.1),
  v_sign = c(-1, 1),
  continuous = FALSE
)
}
\arguments{
\item{pk}{vector of the number of variables per group, defining the block
structure.}

\item{v_within}{vector defining the (range of) nonzero entries in the
diagonal blocks. If \code{continuous=FALSE}, \code{v_within} is the set of
possible values. If \code{continuous=FALSE}, \code{v_within} is the range
of possible values.}

\item{v_between}{vector defining the (range of) nonzero entries in the
off-diagonal blocks. If \code{continuous=FALSE}, \code{v_between} is the
set of possible precision values. If \code{continuous=FALSE},
\code{v_between} is the range of possible precision values. This argument
is only used if \code{length(pk)>1}.}

\item{v_sign}{vector of possible signs for matrix entries. Possible
inputs are: \code{-1} for negative entries only, \code{1} for
positive entries only, or \code{c(-1, 1)} for both positive and
negative entries.}

\item{continuous}{logical indicating whether to sample precision values from
a uniform distribution between the minimum and maximum values in
\code{v_within} (diagonal blocks) or \code{v_between} (off-diagonal blocks)
(\code{continuous=TRUE}) or from proposed values in \code{v_within}
(diagonal blocks) or \code{v_between} (off-diagonal blocks)
(\code{continuous=FALSE}).}
}
\value{
A symmetric matrix with uniformly distributed entries sampled from
  different distributions for diagonal and off-diagonal blocks.
}
\description{
Simulates a symmetric matrix with block structure. Matrix entries are
sampled from (i) a discrete uniform distribution taking values in
\code{v_within} (for entries in the diagonal block) or \code{v_between} (for
entries in off-diagonal blocks) if \code{continuous=FALSE}, or (ii) a
continuous uniform distribution taking values in the range given by
\code{v_within} or \code{v_between} if \code{continuous=TRUE}.
}
\keyword{internal}
