% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFD.R
\name{FFD}
\alias{FFD}
\title{Frost-Free Day Evaluation}
\usage{
FFD(
  d,
  returnDailyPr = TRUE,
  minDays = 165,
  frostTemp = 32,
  endSpringDOY = 182,
  startFallDOY = 213
)
}
\arguments{
\item{d}{\code{data.frame} with columns 'datetime' 'year', and 'value'; 'value' being daily minimum temperature, see details}

\item{returnDailyPr}{optionally return \code{list} with daily summaries}

\item{minDays}{min number of days of non-NA data in spring | fall, required for a reasonable estimate of FFD}

\item{frostTemp}{critical temperature that defines "frost" (same units as \code{d$value})}

\item{endSpringDOY}{day of year that marks end of "spring" (typically Jan 1 -- June 30)}

\item{startFallDOY}{day of year that marks start of "fall" (typically Aug 1 -- Dec 31)}
}
\value{
a \code{data.frame} when a \code{returnDailyPr=FALSE}, otherwise a \code{list} with the following elements:
\itemize{
\item summary: FFD summary statistics as a \code{data.frame}
\item fm: frost matrix
\item Pr.frost: Pr(frost|day): daily probability of frost
}
}
\description{
Evaluation frost-free days and related metrics from daily climate records.
}
\details{
The default \code{frostTemp=32} is suitable for use with minimum daily temperatures in degrees Fahrenheit. Use \code{frostTemp = 0} for temperatures in degrees Celsius.

\href{http://ncss-tech.github.io/AQP/sharpshootR/FFD-estimates.html}{FFD tutorial}
}
\examples{

# 11 years of data from highland meadows
data('HHM', package = 'sharpshootR')
x.ffd <- FFD(HHM, returnDailyPr = FALSE, frostTemp = 32)

str(x.ffd)

}
\author{
D.E. Beaudette
}
