% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Shmulate.R
\name{shmulateSeq}
\alias{shmulateSeq}
\title{Simulate mutations in a single sequence}
\usage{
shmulateSeq(sequence, mutations, targetingModel = HS5FModel)
}
\arguments{
\item{sequence}{sequence string in which mutations are to be introduced.}

\item{mutations}{number of mutations to be introduced into \code{sequence}.}

\item{targetingModel}{5-mer \link{TargetingModel} object to be used for computing 
probabilities of mutations at each position. Defaults to
\link{HS5FModel}.}
}
\value{
A string defining the mutated sequence.
}
\description{
Generates random mutations in a sequence iteratively using a targeting model.
Targeting probabilities at each position are updated after each iteration.
}
\examples{
# Define example input sequence
sequence <- "NGATCTGACGACACGGCCGTGTATTACTGTGCGAGAGATAGTTTA"

# Simulate using the default human 5-mer targeting model
shmulateSeq(sequence, mutations=6)

}
\seealso{
See \link{shmulateTree} for imposing mutations on a lineage tree. 
          See \link{HS5FModel} and \link{MRS5NFModel} for predefined 
          \link{TargetingModel} objects.
}

