% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{summarizeBaseline}
\alias{summarizeBaseline}
\title{Calculate BASELINe summary statistics}
\usage{
summarizeBaseline(baseline, returnType = c("baseline", "df"), nproc = 1)
}
\arguments{
\item{baseline}{\code{Baseline} object returned by \link{calcBaseline} containing 
annotations and BASELINe posterior probability density functions 
(PDFs) for each sequence.}

\item{returnType}{One of \code{c("baseline", "df")} defining whether
to return a \code{Baseline} object ("baseline") with an updated
\code{stats} slot or a data.frame ("df") of summary statistics.}

\item{nproc}{number of cores to distribute the operation over. If 
\code{nproc} = 0 then the \code{cluster} has already been
set and will not be reset.}
}
\value{
Either a modified \code{Baseline} object or data.frame containing the 
          BASELINe selection strength, 95\% confidence intervals and P-value.
}
\description{
\code{summarizeBaseline} calculates BASELINe statistics such as the selection strength
(Sigma), the 95\% confidence intervals and P-values.
}
\examples{
# Subset example data
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE \%in\% c("IgA", "IgG") & SAMPLE == "+7d")

# Calculate BASELINe
baseline <- calcBaseline(db, 
                         sequenceColumn="SEQUENCE_IMGT",
                         germlineColumn="GERMLINE_IMGT_D_MASK", 
                         testStatistic="focused",
                         regionDefinition=IMGT_V_NO_CDR3,
                         targetingModel = HS5FModel,
                         nproc = 1)

# Grouping the PDFs by the sample and isotype annotations
grouped <- groupBaseline(baseline, groupBy=c("SAMPLE", "ISOTYPE"))

# Get a data.frame of the summary statistics
stats <- summarizeBaseline(grouped, returnType="df")
                     
}
\seealso{
See \link{calcBaseline} for generating \code{Baseline} objects and
          \link{groupBaseline} for convolving groups of BASELINe PDFs.
}

