% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsl.R
\name{uimenu}
\alias{uimenu}
\title{Create Semantic UI Menu}
\usage{
uimenu(..., type = "")
}
\arguments{
\item{...}{Menu items to be created. Use menu_item function to create new menu item. Use uidropdown(is_menu_item = TRUE, ...)
function to create new dropdown menu item. Use menu_header and menu_divider functions to customize menu format.}

\item{type}{Type of the menu. Look at https://semantic-ui.com/collections/menu.html for all possiblities.}
}
\description{
This creates a menu using Semantic UI.
}
\examples{

if (interactive()){
library(shiny)
library(shiny.semantic)

ui <- function() {
  shinyUI(
    semanticPage(
      title = "My page",
      suppressDependencies("bootstrap"),
      uimenu(menu_item("Menu"),
             uidropdown(
               "Action",
               uimenu(
                 menu_header(uiicon("file"), "File", is_item = FALSE),
                 menu_item(uiicon("wrench"), "Open"),
                 menu_item(uiicon("upload"), "Upload"),
                menu_item(uiicon("remove"), "Upload"),
                 menu_divider(),
                 menu_header(uiicon("user"), "User", is_item = FALSE),
                 menu_item(uiicon("add user"), "Add"),
                 menu_item(uiicon("remove user"), "Remove")),
               type = "",
               name = "unique_name",
               is_menu_item = TRUE),
             menu_item(uiicon("user"), "Profile", href = "#index", item_feature = "active"),
             menu_item("Projects", href = "#projects"),
             menu_item(uiicon("users"), "Team"),
             uimenu(menu_item(uiicon("add icon"), "New tab"), type = "right"))
    )
  )
}

server <- shinyServer(function(input, output) {
})

shinyApp(ui = ui(), server = server)
}
}
