% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{progress}
\alias{progress}
\title{Create progress Semantic UI component}
\usage{
progress(
  input_id,
  value = NULL,
  total = NULL,
  percent = NULL,
  progress_lab = FALSE,
  label = NULL,
  label_complete = NULL,
  size = "",
  class = NULL
)
}
\arguments{
\item{input_id}{Input name. Reactive value is available under input[[input_id]].}

\item{value}{The initial value to be selected for the progress bar.}

\item{total}{The maximum value that will be applied to the progress bar.}

\item{percent}{The initial percentage to be selected for the progress bar.}

\item{progress_lab}{Logical, would you like the percentage visible in the progress bar?}

\item{label}{The label to be visible underneath the progress bar.}

\item{label_complete}{The label to be visible underneath the progress bar when the bar is at 100\%.}

\item{size}{character with legal semantic size, eg. "medium", "huge", "tiny"}

\item{class}{UI class of the progress bar.}
}
\description{
This creates a default progress using Semantic UI styles with Shiny input.
Progress is already initialized and available under input[[input_id]].
}
\details{
To initialize the progress bar, you can either choose \code{value} and \code{total}, or \code{percent}.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

  library(shiny)
  library(shiny.semantic)
  ui <- function() {
      shinyUI(
        semanticPage(
          title = "Progress example",
          progress("progress", percent = 24, label = "{percent}\% complete"),
          p("Progress completion:"),
          textOutput("progress")
       )
     )
  }
  server <- shinyServer(function(input, output) {
     output$progress <- renderText(input$progress)
  })

  shinyApp(ui = ui(), server = server)
}

}
