% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-storage-mariadb.R
\name{DataStorageMariaDB}
\alias{DataStorageMariaDB}
\title{Data storage class with MariaDB / MySQL provider}
\description{
Implementation of the \code{\link{DataStorage}} R6 class to MariaDB backend using a
unified API for read/write operations
}
\examples{
\dontrun{
data_storage <- DataStorageMariaDB$new(user = "mariadb", password = "mysecretpassword")

data_storage$insert("example", "test_event", "session1")
data_storage$insert("example", "input", "s1", list(id = "id1"))
data_storage$insert("example", "input", "s1", list(id = "id2", value = 32))

data_storage$insert(
  "example", "test_event_3_days_ago", "session1",
  time = lubridate::as_datetime(lubridate::today() - 3)
)

data_storage$read_event_data()
data_storage$read_event_data(Sys.Date() - 1, Sys.Date() + 1)
data_storage$close()
}
}
\section{Super classes}{
\code{\link[shiny.telemetry:DataStorage]{shiny.telemetry::DataStorage}} -> \code{\link[shiny.telemetry:DataStorageSQLFamily]{shiny.telemetry::DataStorageSQLFamily}} -> \code{DataStorageMariaDB}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataStorageMariaDB-new}{\code{DataStorageMariaDB$new()}}
\item \href{#method-DataStorageMariaDB-clone}{\code{DataStorageMariaDB$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="close"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-close'><code>shiny.telemetry::DataStorage$close()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="insert"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-insert'><code>shiny.telemetry::DataStorage$insert()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="read_event_data"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-read_event_data'><code>shiny.telemetry::DataStorage$read_event_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorageMariaDB-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorageMariaDB-new}{}}}
\subsection{Method \code{new()}}{
Initialize the data storage class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorageMariaDB$new(
  username = NULL,
  password = NULL,
  hostname = "127.0.0.1",
  port = 3306,
  dbname = "shiny_telemetry"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{username}}{string with a MariaDB username.}

\item{\code{password}}{string with the password for the username.}

\item{\code{hostname}}{string with hostname of MariaDB instance.}

\item{\code{port}}{numeric value with the port number of MariaDB instance.}

\item{\code{dbname}}{string with the name of the database in the MariaDB
instance.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorageMariaDB-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorageMariaDB-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorageMariaDB$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
