% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-input.R
\name{updateSliderInput}
\alias{updateSliderInput}
\title{Update Slider Input Widget}
\usage{
updateSliderInput(
  session = getDefaultReactiveDomain(),
  inputId,
  label = NULL,
  value = NULL,
  min = NULL,
  max = NULL,
  step = NULL,
  timeFormat = NULL,
  timezone = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}. Default is \code{getDefaultReactiveDomain()}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The initial value of the slider, either a number, a date
(class Date), or a date-time (class POSIXt). A length one vector will
create a regular slider; a length two vector will create a double-ended
range slider. Must lie between \code{min} and \code{max}.}

\item{min}{The minimum and maximum values (inclusive) that can be
selected.}

\item{max}{The minimum and maximum values (inclusive) that can be
selected.}

\item{step}{Specifies the interval between each selectable value on the
slider. Either \code{NULL}, the default, which uses a heuristic to determine the
step size or a single number. If the values are dates, \code{step} is in days;
if the values are date-times, \code{step} is in seconds.}

\item{timeFormat}{Only used if the values are Date or POSIXt objects. A time
format string, to be passed to the Javascript strftime library. See
\url{https://github.com/samsonjs/strftime} for more details. The allowed
format specifications are very similar, but not identical, to those for R's
\code{\link[base:strptime]{base::strftime()}} function. For Dates, the default is \code{"\%F"}
(like \code{"2015-07-01"}), and for POSIXt, the default is \code{"\%F \%T"}
(like \code{"2015-07-01 15:32:10"}).}

\item{timezone}{Only used if the values are POSIXt objects. A string
specifying the time zone offset for the displayed times, in the format
\code{"+HHMM"} or \code{"-HHMM"}. If \code{NULL} (the default), times will
be displayed in the browser's time zone. The value \code{"+0000"} will
result in UTC time.}
}
\description{
Change the value of a slider input on the client.
}
\details{
The input updater functions send a message to the client, telling it to
change the settings of an input object. The messages are collected and sent
after all the observers (including outputs) have finished running.

The syntax of these functions is similar to the functions that created the
inputs in the first place. For example, \code{\link{numericInput}()} and
\code{updateNumericInput()} take a similar set of arguments.

Any arguments with NULL values will be ignored; they will not result in any
changes to the input object on the client.

For \code{\link{radioButtons}()}, \code{\link{checkboxGroupInput}()} and
\code{\link{selectInput}()}, the set of choices can be cleared by using
\code{choices=character(0)}. Similarly, for these inputs, the selected item
can be cleared by using \code{selected=character(0)}.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  shinyApp(
    ui = fluidPage(
      sidebarLayout(
        sidebarPanel(
          p("The first slider controls the second"),
          sliderInput("control", "Controller:", min=0, max=20, value=10,
                       step=1),
          sliderInput("receive", "Receiver:", min=0, max=20, value=10,
                       step=1)
        ),
        mainPanel()
      )
    ),
    server = function(input, output, session) {
      observe({
        val <- input$control
        # Control the value, min, max, and step.
        # Step size is 2 when input value is even; 1 when value is odd.
        updateSliderInput(session, "receive", value = val,
          min = floor(val/2), max = val+4, step = (val+1)\%\%2 + 1)
      })
    }
  )
}
}
\seealso{
\code{\link[=sliderInput]{sliderInput()}}
}
