% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Init.R
\name{f7Init}
\alias{f7Init}
\title{Custom initialization}
\usage{
f7Init(
  skin = c("ios", "md", "auto", "aurora"),
  theme = c("dark", "light"),
  filled = FALSE,
  color = NULL,
  tapHold = TRUE,
  tapHoldDelay = 750,
  pullToRefresh = FALSE,
  iosTouchRipple = FALSE,
  iosCenterTitle = TRUE,
  iosTranslucentBars = FALSE,
  hideNavOnPageScroll = FALSE,
  hideTabsOnPageScroll = FALSE,
  serviceWorker = NULL
)
}
\arguments{
\item{skin}{App skin: "ios", "md", "auto" or "aurora".}

\item{theme}{App theme: "light" or "dark".}

\item{filled}{Whether to fill the \link{f7Navbar} and \link{f7Toolbar} with
the current selected color. FALSE by default.}

\item{color}{Color theme: See \url{http://framework7.io/docs/color-themes.html}.
Expect a name like blue or red. If NULL, use the default color.}

\item{tapHold}{It triggers (if enabled) after a sustained, complete touch event.
By default it is disabled. Note, that Tap Hold is a part of built-in Fast Clicks library,
so Fast Clicks should be also enabled.}

\item{tapHoldDelay}{Determines how long (in ms) the user must hold their tap before the taphold event is fired on the target element.
Default to 750 ms.}

\item{pullToRefresh}{Whether to active the pull to refresh feature. Default to FALSE.}

\item{iosTouchRipple}{Default to FALSE. Enables touch ripple effect for iOS theme.}

\item{iosCenterTitle}{Default to TRUE. When enabled then it will try to position
title at the center in iOS theme. Sometime (with some custom design) it may not needed.}

\item{iosTranslucentBars}{Enable translucent effect (blur background) on navigation bars for iOS theme (on iOS devices).
FALSE by default.}

\item{hideNavOnPageScroll}{Default to FALSE. Will hide Navbars on page scroll.}

\item{hideTabsOnPageScroll}{Default to FALSE. Will hide tabs on page scroll.}

\item{serviceWorker}{Object with service worker module parameters. (Use for PWA).}
}
\description{
Use inside \link{f7Page}. Mandatory!
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
