% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Toggle}
\alias{f7Toggle}
\title{Create a F7 toggle switch}
\usage{
f7Toggle(inputId, label, checked = FALSE, color = NULL)
}
\arguments{
\item{inputId}{Toggle input id.}

\item{label}{Toggle label.}

\item{checked}{Whether to check the toggle. FALSE by default.}

\item{color}{Toggle color: NULL or "red", "green", "blue", "pink", "yellow", "orange", "grey" and "black".}
}
\description{
Create a F7 toggle switch
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Toggle"),
     f7Toggle(
      inputId = "toggle",
      label = "My toggle",
      color = "pink",
      checked = TRUE
     ),
     verbatimTextOutput("test"),
     f7Toggle(
      inputId = "toggle2",
      label = "My toggle 2"
     ),
     verbatimTextOutput("test2")
    )
   ),
   server = function(input, output) {
    output$test <- renderPrint(input$toggle)
    output$test2 <- renderPrint(input$toggle2)
   }
 )
}
}
