% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7checkBox}
\alias{f7checkBox}
\title{Create a F7 Checkbox}
\usage{
f7checkBox(inputId, label, value = FALSE)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Display label for the control, or NULL for no label.}

\item{value}{Initial value (TRUE or FALSE).}
}
\description{
Create a F7 Checkbox
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7checkBox"),
     f7Card(
      f7checkBox(
       inputId = "check",
       label = "Checkbox",
       value = FALSE
      ),
      verbatimTextOutput("test")
     )
    )
   ),
   server = function(input, output) {
    output$test <- renderPrint({input$check})
   }
 )
}
}
