% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Toast.R
\name{f7Toast}
\alias{f7Toast}
\title{Framework7 toast}
\usage{
f7Toast(
  text,
  position = c("bottom", "top", "center"),
  closeButton = TRUE,
  closeButtonText = "close",
  closeButtonColor = "red",
  closeTimeout = 3000,
  icon = NULL,
  ...,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{text}{Toast content.}

\item{position}{Toast position \code{c("bottom", "top", "center")}.}

\item{closeButton}{Whether to close the toast with a button.
TRUE by default.}

\item{closeButtonText}{Close button text.}

\item{closeButtonColor}{Close button color.}

\item{closeTimeout}{Time before toast closes.}

\item{icon}{Optional. Expect \link{f7Icon}. Warning:
Adding icon will hide the close button.}

\item{...}{Other options. See \url{https://framework7.io/docs/toast.html#toast-parameters}.}

\item{session}{Shiny session.}
}
\description{
\code{f7Toast} creates a small toast notification from the server side.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "Toast",
    f7SingleLayout(
      navbar = f7Navbar(title = "f7Toast"),
      f7Button(inputId = "toast", label = "Open Toast")
    )
  ),
  server = function(input, output, session) {
    observeEvent(input$toast, {
      f7Toast(
        position = "top",
        text = "I am a toast. Eat me!"
      )
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app

}
