% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_plotSbm.R
\name{plotSbm.matrix}
\alias{plotSbm.matrix}
\title{plotSbm.matrix Method}
\usage{
\method{plotSbm}{matrix}(
  x,
  ordered = FALSE,
  transpose = FALSE,
  labels = NULL,
  plotOptions = list()
)
}
\arguments{
\item{x}{numeric matrix}

\item{ordered}{Boolean. Set \code{TRUE} if the matrix should be reordered (Default is \code{FALSE})}

\item{transpose}{Boolean. Set \code{TRUE} to invert columns and rows to flatten a long matrix (Default is \code{FALSE})}

\item{labels}{named list (names should be: `"col"` and `"row"`) of characters describing columns and rows component (Default is \code{NULL})}

\item{plotOptions}{list providing options. See details below.}
}
\value{
a ggplot object corresponding to the matrix plot inside the app.
Here because there no 'sbm' information and only a matrix describing a network,
The matrix isn't organized and the tiles are only showing individuals connections.
}
\description{
plotSbm method for matrix object
}
\details{
The list of parameters \code{plotOptions} for the matrix plot is
\itemize{
 \item{"showValues": }{Boolean. Set TRUE to see the real values. Default value is TRUE}
 \item{"showPredictions": }{Boolean. Set TRUE to see the predicted values. Default value is TRUE}
 \item{"title": }{Title in characters. Will be printed at the bottom of the matrix. Default value is NULL}
 \item{"colPred": }{Color of the predicted values, the small values will be more transparent. Default value is "red"}
 \item{"colValue": }{Color of the real values, the small values will close to white. Default value is "black"}
 \item{"showLegend": }{Should a legend be printed ? TRUE or FALSE, default:  FALSE}
 \item{"interactionName": }{Name of connection in legend default: "Connection"}
}
}
\examples{
n_col <- 100
n_row <- 90
mat <- matrix(sample(0:10, n_col * n_row, replace = TRUE), n_col, n_row)
plotSbm(mat,
  transpose = TRUE,
  labels = list(col = "Columns", row = "Rows"),
  plotOptions = list(colValue = "blue")
)

}
