% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buttons.R
\name{appButton}
\alias{appButton}
\title{AdminLTE2 special large button}
\usage{
appButton(url = NULL, label = NULL, icon = NULL, enable_badge = FALSE,
  badgeColor = NULL, badgeLabel = NULL)
}
\arguments{
\item{url}{if the button should redirect somewhere.}

\item{label}{button label.}

\item{icon}{button icon, if any. Should be written like "fa fa-times".}

\item{enable_badge}{Whether to display a badge on the top-right corner of the button.}

\item{badgeColor}{color of the badge: see here for a list of valid colors \url{https://adminlte.io/themes/AdminLTE/pages/UI/general.html}.}

\item{badgeLabel}{text to display in the badge. I personally recommend you to only put numbers.}
}
\description{
Create a large button ideal for web applications
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "App Buttons",
      status = NULL,
      appButton(
        url = "http://google.com",
        label = "Users", 
        icon = "fa fa-users", 
        enable_badge = TRUE, 
        badgeColor = "purple", 
        badgeLabel = 891
      ),
      appButton(
        label = "Edit", 
        icon = "fa fa-edit", 
        enable_badge = FALSE, 
        badgeColor = NULL, 
        badgeLabel = NULL
      ),
      appButton(
        label = "Likes", 
        icon = "fa fa-heart-o", 
        enable_badge = TRUE, 
        badgeColor = "red", 
        badgeLabel = 3
      )
     )
    ),
    title = "Buttons"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
