% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verticalProgress.R
\name{verticalProgress}
\alias{verticalProgress}
\title{AdminLTE2 vertical progress bar}
\usage{
verticalProgress(value, min = 0, max = 100, height = "40\%",
  striped = FALSE, active = FALSE, status = "primary", size = NULL)
}
\arguments{
\item{value}{Progress bar value. Must be between min and max.}

\item{min}{Progress bar minimum value (0 by default).}

\item{max}{Progress bar maximum value (100 by default).}

\item{height}{Progress bar default height (40 percent by default).}

\item{striped}{Whether the progress is striped or not. FALSE by default.}

\item{active}{Whether the progress is active or not. FALSE by default.}

\item{status}{Progress bar status. "primary" by default or "warning", "info",
"danger" or "success".}

\item{size}{Progress bar size. NULL by default: "sm", "xs" or "xxs" also available.}
}
\description{
This creates a vertical progress bar.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
   ui = dashboardPagePlus(
     header = dashboardHeaderPlus(
      enable_rightsidebar = TRUE,
      rightSidebarIcon = "gears"
     ),
     sidebar = dashboardSidebar(),
     body = dashboardBody(
      verticalProgress(
       value = 10,
       striped = TRUE,
       active = TRUE
      ),
      verticalProgress(
       value = 50,
       active = TRUE,
       status = "warning",
       size = "xs"
      ),
      verticalProgress(
       value = 20,
       status = "danger",
       size = "sm",
       height = "60\%"
      )
     ),
     rightsidebar = rightSidebar(),
     title = "Right Sidebar"
   ),
   server = function(input, output) { }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
