% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTest.R
\name{wrapTTest.numeric}
\alias{wrapTTest.numeric}
\title{Wrap t.test (difference in means by group).}
\usage{
\method{wrapTTest}{numeric}(
  x,
  pop2,
  ...,
  y = NULL,
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  paired = FALSE,
  var.equal = FALSE,
  conf.level = 0.95,
  na.rm = FALSE
)
}
\arguments{
\item{x}{numeric population 1}

\item{pop2}{numeric population 2}

\item{...}{extra arguments passed to ttest}

\item{y}{passed to \code{\link[stats]{t.test}}}

\item{alternative}{passed to \code{\link[stats]{t.test}}}

\item{mu}{passed to \code{\link[stats]{t.test}}}

\item{paired}{passed to \code{\link[stats]{t.test}}}

\item{var.equal}{passed to \code{\link[stats]{t.test}}}

\item{conf.level}{passed to \code{\link[stats]{t.test}}}

\item{na.rm}{logical, if TRUE remove NA values}
}
\value{
formatted string and fields
}
\description{
Wrap t.test (difference in means by group).
}
\examples{

d <- data.frame(x=c(1,2,3,4,5,6,7,7),
                y=c(1,1,2,2,3,3,4,4))
render(wrapTTest(d$x, d$y), pLargeCutoff=1)
# confirm p not order depedent
render(wrapTTest(d$y, d$x),pLargeCutoff=1)

}
