% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_Shuttleworth_Wallace.R
\name{cal_latentHeatFluxesForSoil}
\alias{cal_latentHeatFluxesForSoil}
\title{Calculating latent heat fluxes for soil}
\usage{
cal_latentHeatFluxesForSoil(
  DELTA,
  As,
  rho_cp = 1221.09,
  D0,
  r_s_a,
  gamma = 0.658,
  r_s_s
)
}
\arguments{
\item{DELTA}{the slope of the saturated vapor pressure curve (mbar K-1)}

\item{As}{energy available to the soil (W m-2 ground)}

\item{rho_cp}{the volumetric heat capacity for air (1221.09 J m-3 K-1)}

\item{D0}{the vapor pressure deficit at the mean canopy flow}

\item{r_s_a}{the aerodynamic resistance between the soil and mean canopy flow (s m-1)}

\item{gamma}{the psychometric constant (0.658 mbar K-1)}

\item{r_s_s}{soil surface resistance,  (s m-1)}
}
\value{
A vector for soil latent heat fluxes (W m-2 ground)
}
\description{
Calculating latent heat fluxes for soil
}
