\name{specifyInput}
\alias{specifyInput}
\title{
  create an object of class 'dataObj' required for further processing
}
\author{Bernhard Meindl}
\description{
  create an standardized input object of class 'dataObj' containing information on weights, household ids, household sizes, person ids and optionally strata. Outputs of this function are typically used in \code{\link{simStructure}}.
}
\usage{
specifyInput(data, hhid, hhsize=NULL, pid=NULL, weight, strata=NULL)
}
\arguments{
  \item{data}{a \code{data.frame} or \code{data.table} featuring sample data.}
  \item{hhid}{character vector of length 1 specifying variable containing household ids within slot \code{data}.}
  \item{hhsize}{character vector of length 1 specifying variable containing household sizes within slot \code{data}. If NULL, household sizes are automatically calculated.}
  \item{pid}{character vector of length 1 specifying variable containing person ids within slot \code{data}. If NULL, person ids are automatically calculated.}
  \item{weight}{character vector of length 1 specifying variable holding sampling weights within slot \code{data}.}
  \item{strata}{character vector of length 1 specifing variable name within slot \code{data} of variable holding information on strata, e.g. regions or NULL if such variable does not exist.}
}
\examples{
data(eusilcS)
inp <- specifyInput(data=eusilcS, hhid="db030", weight="rb050", strata="db040")
print(class(inp))
str(inp)
}
\keyword{method}
