% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{utility}
\alias{utility}
\alias{utilityIndicator}
\alias{utilityModal}
\title{Utility measures}
\usage{
utility(x, y, type = c("all", "compareColumns", "compareRows",
  "compareRowsHH", "compareNA"), hhid = NULL)

utilityModal(x, y, varx, vary = NULL)

utilityIndicator(x, y)
}
\arguments{
\item{x}{a data.frame, typically the original data set. For \code{utilityIndicator} this should be a vector of length 1.}

\item{y}{a data.frame, typically the corresponding synthetic data set. For \code{utilityIndicator} this should be a vector of length 1.}

\item{type}{which measure
\itemize{
 \item{compareColumns}{compares the intersection of variables}
 \item{compareRows}{compares the number of rows}
 \item{compareRowsHH}{compares the number of housholds}
 \item{compareNA}{compares the number of missings}
}}

\item{hhid}{index or name of variable containing the houshold ID}

\item{varx}{name or index of a variable in data.frame x}

\item{vary}{NULL or name or index of a variable in data.frame y corresponding to variable varx in data.frame x. 
If NULL, the names of the selected variable should be the same in both x and y.}
}
\value{
the measure(s) of interest
}
\description{
Various utility measues that basically compares two data sets
}
\section{Functions}{
\itemize{
\item \code{utility}: comparisons of two data sets

\item \code{utilityModal}: comparison of number of categories

\item \code{utilityIndicator}: difference between two values
}}
\examples{
data(eusilcS)
data(eusilcP)
## for fast caluclations, took a subsample
eusilcP <- eusilcP[1:15000, ]
utility(eusilcS, eusilcP)
data(eusilcS)
data(eusilcP)
utilityModal(eusilcS, eusilcP, "age")
utilityModal(eusilcS, eusilcP, "pl030", "ecoStat")
data(eusilcS)
data(eusilcP)
m1 <- meanWt(eusilcS$age, eusilcS$rb050) 
m2 <- mean(eusilcP$age)
utilityIndicator(m1, m2)
}
\author{
Matthias Templ, Maxime Bergeaut
}

