% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Data.R
\name{simer.Data.Impute}
\alias{simer.Data.Impute}
\title{Genotype data imputation}
\usage{
simer.Data.Impute(
  fileMVP = NULL,
  fileBed = NULL,
  out = NULL,
  maxLine = 10000,
  ncpus = 0,
  verbose = TRUE
)
}
\arguments{
\item{fileMVP}{genotype in MVP format.}

\item{fileBed}{genotype in PLINK binary format.}

\item{out}{the name of output file.}

\item{maxLine}{number of SNPs, only used for saving memory when calculate kinship matrix.}

\item{ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}

\item{verbose}{whether to print detail.}
}
\value{
the function returns files
\describe{
\item{<out>.geno.desc}{the description file of genotype data.}
\item{<out>.geno.bin}{the binary file of genotype data.}
\item{<out>.geno.ind}{the genotyped individual file.}
\item{<out>.geno.map}{the marker information data file.}
}
}
\description{
Impute the missing value within genotype data.
}
\details{
Build date: May 26, 2021
Last update: Apr 28, 2022
}
\examples{
# Get the prefix of genotype data
fileMVP <- system.file("extdata", "02plinkb", "demo", package = "simer")

\dontrun{
# It needs 'beagle' software
fileMVPimp <- simer.Data.Impute(fileBed = fileBed)
}
}
\author{
Dong Yin
}
