% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Data.R
\name{simer.Data.Geno}
\alias{simer.Data.Geno}
\title{Genotype data quality control}
\usage{
simer.Data.Geno(
  fileMVP = NULL,
  fileBed = NULL,
  filePlinkPed = NULL,
  filePed = NULL,
  filePhe = NULL,
  out = "simer.qc",
  genoType = "char",
  filter = NULL,
  filterGeno = NULL,
  filterHWE = NULL,
  filterMind = NULL,
  filterMAF = NULL,
  ncpus = 0,
  verbose = TRUE
)
}
\arguments{
\item{fileMVP}{genotype in MVP format.}

\item{fileBed}{genotype in PLINK binary format.}

\item{filePlinkPed}{genotype in PLINK numeric format.}

\item{filePed}{the filename of pedigree data.}

\item{filePhe}{the filename of phenotype data, it can be a vector.}

\item{out}{the prefix of output files.}

\item{genoType}{type parameter in bigmemory, genotype data. The default is char, it is highly recommended *NOT* to modify this parameter.}

\item{filter}{filter of genotyped individual.}

\item{filterGeno}{threshold of sample miss rate.}

\item{filterHWE}{threshold of Hardy-Weinberg Test.}

\item{filterMind}{threshold of variant miss rate.}

\item{filterMAF}{threshold of Minor Allele Frequency.}

\item{ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}

\item{verbose}{whether to print detail.}
}
\value{
the function returns files
\describe{
\item{<out>.bed}{the .bed file of PLINK binary format.}
\item{<out>.bim}{the .bim file of PLINK binary format.}
\item{<out>.fam}{the .fam file of PLINK binary format.}
}
}
\description{
Data quality control for genotype data in MVP format and PLINK format.
}
\details{
Build date: May 26, 2021
Last update: Apr 28, 2022
}
\examples{
# Get the prefix of genotype data
fileBed <- system.file("extdata", "02plinkb", "demo", package = "simer")

\dontrun{
# It needs 'plink' software
simer.Data.Geno(fileBed=fileBed)
}
}
\author{
Dong Yin
}
