% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfa_get_shares.R
\name{sfa_get_shares}
\alias{sfa_get_shares}
\title{Shares Outstanding}
\usage{
sfa_get_shares(
  ticker = NULL,
  simfin_id = NULL,
  type,
  period = NULL,
  fyear = NULL,
  start = NULL,
  end = NULL,
  api_key = getOption("sfa_api_key"),
  cache_dir = getOption("sfa_cache_dir"),
  sfplus = getOption("sfa_sfplus", default = FALSE)
)
}
\arguments{
\item{ticker}{\link{integer} Ticker of the companies of interest.}

\item{simfin_id}{\link{integer} 'SimFin' IDs of the companies of interest. Any
\code{simfin_id} will be internally translated to the respective \code{ticker}. This
reduces the number of queries in case you query the same company via
\code{ticker} \emph{and} \code{simfin_id}.}

\item{type}{\link{character} Type of shares outstanding to be retrieved.
\itemize{
\item \code{"common"}: Common shares outstanding.
\item \code{"wa-basic"}: Weighted average basic shares outstanding for a period.
\item \code{"wa-diluted"}: Weighted average diluted shares outstanding for a period.
}}

\item{period}{\link{character} Filter for periods. Only works with \code{type = wa-basic} and \code{type = wa-diluted}. This filter can be omitted to retrieve
all shares outstanding available for the company.
\itemize{
\item \code{"q1"}: First fiscal quarter.
\item \code{"q2"}: Second fiscal quarter.
\item \code{"q3"}: Third fiscal quarter.
\item \code{"q4"}: Fourth fiscal quarter.
\item \code{"fy"}: Full fiscal year.
\item \code{"h1"}: First 6 months of fiscal year.
\item \code{"h2"}: Last 6 months of fiscal year.
\item \code{"9m"}: First nine months of fiscal year.
\item \code{"6m"}: Any fiscal 6 month period (first + second half years).
\item \code{"quarters"}: All quarters (q1 + q2 + q3 + q4).
}

You can select several periods by passing several of the above items at
once, e.g. \code{period = c("q1", "q2")}.}

\item{fyear}{\link{integer} Filter for fiscal year. As a non-SimFin+ user, you
have to provide exactly one fiscal year. As SimFin+ user, this filter can
be omitted to retrieve all data available for the company.}

\item{start}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending AFTER the specified
date.}

\item{end}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending BEFORE the specified
date.}

\item{api_key}{\link{character} Your 'SimFin' API key. It's recommended to set
the API key globally using \link{sfa_set_api_key}.}

\item{cache_dir}{\link{character} Your cache directory. It's recommended to set
the cache directory globally using \link{sfa_set_cache_dir}.}

\item{sfplus}{\link{logical} Set\code{TRUE} if you have a SimFin+ account. It's
recommended to set \code{sfplus} globally using \link{sfa_set_sfplus}.}
}
\description{
Common shares outstanding (point-in-time) and weighted average
basic/diluted shares outstanding for all periods can be retrieved here.
These shares are the aggregate figures for the entire company. If you are
interested in more details, take a look at this page:
https://www.simfin.com/data/help/main?topic=apiv2-shares
}
\section{Fiscal year}{
 Only works with \code{type = "wa-basic"} and \code{type = "wa-diluted"}.
}

\section{Parallel processing}{

This function supports parallel processing via \code{future.apply}. If your
machine has several cores (most have), you can make the API calls in
parallel. To do so, define a \code{future::plan()} before calling the function.
}

